/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kong.unirest.Headers;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import kong.unirest.Util;

class RetryAfter {
    private static final Set<Integer> RETRY_CODES = new HashSet<Integer>(Arrays.asList(429, 529, 301));
    private static final String RETRY_AFTER = "Retry-After";
    private static final RetryAfter EMPTY = new RetryAfter(0L);
    private long millies;

    RetryAfter(Long millies) {
        this.millies = millies;
    }

    static RetryAfter from(HttpResponse response) {
        return RetryAfter.from(response.getHeaders());
    }

    static boolean isRetriable(HttpResponse response) {
        return RETRY_CODES.contains(response.getStatus()) && response.getHeaders().containsKey(RETRY_AFTER);
    }

    static RetryAfter from(Headers response) {
        String value = response.getFirst(RETRY_AFTER);
        return RetryAfter.tryAsDouble(value).orElseGet(() -> RetryAfter.tryAsDateTime(value));
    }

    private static RetryAfter tryAsDateTime(String value) {
        ZonedDateTime zdt = Util.tryParseToDate(value);
        if (zdt == null) {
            return EMPTY;
        }
        Instant now = Util.now();
        long diff = ChronoUnit.MILLIS.between(now, zdt.toInstant());
        return new RetryAfter(diff);
    }

    private static Optional<RetryAfter> tryAsDouble(String s2) {
        try {
            long millies = RetryAfter.parse(s2);
            return Optional.of(new RetryAfter(millies));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    private static long parse(String s2) {
        if (s2.contains(".")) {
            double d = Double.parseDouble(s2);
            return Math.round(d * 1000.0);
        }
        return Long.parseLong(s2) * 1000L;
    }

    long millies() {
        return this.millies;
    }

    void waitForIt() {
        try {
            TimeUnit.MILLISECONDS.sleep(this.millies);
        }
        catch (InterruptedException e) {
            throw new UnirestException(e);
        }
    }

    boolean canWait() {
        return this.millies > 0L;
    }
}

