/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.rest;

import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class DeleteJsonZosmfRequest
extends ZosmfRequest {
    public DeleteJsonZosmfRequest(ZosConnection connection) {
        super(connection);
    }

    @Override
    public Response executeRequest() throws ZosmfRequestException {
        HttpResponse<JsonNode> reply;
        ValidateUtils.checkNullParameter(this.url == null, "url is null");
        try {
            reply = ((HttpRequestWithBody)Unirest.delete(this.url).headers(this.headers)).asJson();
        }
        catch (UnirestException e) {
            throw new ZosmfRequestException(e.getMessage(), e);
        }
        return this.buildResponse(reply);
    }

    @Override
    public void setBody(Object body) {
        throw new IllegalStateException("setting body for this request is invalid");
    }

    @Override
    public void setStandardHeaders() {
        this.headers.put("Authorization", "Basic " + EncodeUtils.encodeAuthComponent(this.connection));
        this.headers.put("Content-Type", "application/json");
        this.headers.put(X_CSRF_ZOSMF_HEADER_KEY, X_CSRF_ZOSMF_HEADER_VALUE);
    }
}

