/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.types.LinkType;

public class ChangeOwnerParams {
    private final Optional<String> owner;
    private final Optional<String> group;
    private final boolean recursive;
    private final Optional<LinkType> links;

    public ChangeOwnerParams(Builder builder) {
        this.owner = Optional.ofNullable(builder.owner);
        this.group = Optional.ofNullable(builder.group);
        this.recursive = builder.recursive;
        this.links = Optional.ofNullable(builder.links);
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public Optional<String> getGroup() {
        return this.group;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public Optional<LinkType> getLinks() {
        return this.links;
    }

    public String toString() {
        return "ChangeOwnerParams{owner='" + this.owner + "', group=" + this.group + ", recursive=" + this.recursive + ", links=" + this.links + "}";
    }

    public static class Builder {
        private String owner;
        private String group;
        private boolean recursive = false;
        private LinkType links;

        public Builder owner(String owner) {
            ValidateUtils.checkNullParameter(owner == null, "owner is null");
            ValidateUtils.checkIllegalParameter(owner.isBlank(), "owner not specified");
            this.owner = owner;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Builder links(LinkType type) {
            this.links = type;
            return this;
        }

        public ChangeOwnerParams build() {
            return new ChangeOwnerParams(this);
        }
    }
}

