/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Collection;
import kong.unirest.core.UnirestException;
import kong.unirest.core.json.JSONElement;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JsonEngine;
import kong.unirest.jackson.JacksonArray;
import kong.unirest.jackson.JacksonElement;
import kong.unirest.jackson.JacksonObject;
import kong.unirest.jackson.JacksonObjectMapper;
import kong.unirest.jackson.JacksonPrimitive;

public class JacksonEngine
implements JsonEngine {
    private ObjectMapper om;
    private kong.unirest.core.ObjectMapper objm = new JacksonObjectMapper();

    public JacksonEngine() {
        this.om = JsonMapper.builder().enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES).build();
    }

    @Override
    public String toPrettyJson(JsonEngine.Element obj) {
        try {
            return this.om.writerWithDefaultPrettyPrinter().writeValueAsString(obj.getEngineElement());
        }
        catch (JsonProcessingException e) {
            throw new UnirestException(e);
        }
    }

    @Override
    public String toJson(JsonEngine.Element obj) {
        try {
            return this.om.writeValueAsString(obj.getEngineElement());
        }
        catch (JsonProcessingException e) {
            throw new UnirestException(e);
        }
    }

    @Override
    public void toJson(JsonEngine.Element obj, Writer sw) {
        try {
            this.om.writeValue(sw, obj.getEngineElement());
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    @Override
    public void toPrettyJson(JsonEngine.Element obj, Writer sw) {
        try {
            this.om.writerWithDefaultPrettyPrinter().writeValue(sw, obj.getEngineElement());
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    @Override
    public JsonEngine.Element toJsonTree(Object obj) {
        return JacksonElement.wrap(this.om.convertValue(obj, JsonNode.class));
    }

    @Override
    public JsonEngine.Object newEngineObject() {
        return new JacksonObject(this.om.createObjectNode());
    }

    @Override
    public JsonEngine.Object newEngineObject(String string) throws JSONException {
        try {
            return new JacksonObject(this.om.readValue(string, ObjectNode.class));
        }
        catch (JsonProcessingException e) {
            throw new JSONException("Invalid JSON");
        }
    }

    @Override
    public JsonEngine.Array newJsonArray(String jsonString) throws JSONException {
        try {
            return new JacksonArray(this.om.readValue(jsonString, ArrayNode.class));
        }
        catch (JsonProcessingException e) {
            throw new JSONException("Invalid JSON");
        }
    }

    @Override
    public JsonEngine.Array newJsonArray(Collection<?> collection) {
        JacksonArray a = new JacksonArray(this.om.createArrayNode());
        for (Object o : collection) {
            this.add(a, o);
        }
        return a;
    }

    private void add(JacksonArray a, Object o) {
        if (o instanceof Number) {
            a.add((Number)o);
        } else if (o instanceof String) {
            a.add((String)o);
        } else if (o instanceof Boolean) {
            a.add((Boolean)o);
        } else if (o instanceof JSONElement) {
            a.add(((JSONElement)o).getElement());
        } else if (o instanceof JsonEngine.Element) {
            a.add((JsonEngine.Element)o);
        } else {
            JsonNode tree = this.om.convertValue(o, JsonNode.class);
            a.add(JacksonElement.wrap(tree));
        }
    }

    @Override
    public JsonEngine.Array newEngineArray() {
        return new JacksonArray(this.om.createArrayNode());
    }

    @Override
    public <T> T fromJson(JsonEngine.Element obj, Class<T> mapClass) {
        return this.om.convertValue(obj.getEngineElement(), mapClass);
    }

    @Override
    public <T extends Enum> JsonEngine.Primitive newJsonPrimitive(T enumValue) {
        if (enumValue == null) {
            return new JacksonPrimitive(NullNode.getInstance());
        }
        return this.newJsonPrimitive(enumValue.name());
    }

    @Override
    public JsonEngine.Primitive newJsonPrimitive(String string) {
        return this.convert(string, v -> new TextNode((String)v));
    }

    @Override
    public JsonEngine.Primitive newJsonPrimitive(Number number) {
        if (number instanceof Integer) {
            return this.convert((Integer)number, IntNode::new);
        }
        if (number instanceof Long) {
            return this.convert((Long)number, LongNode::new);
        }
        if (number instanceof Double) {
            return this.convert((Double)number, DoubleNode::new);
        }
        if (number instanceof BigInteger) {
            return this.convert((BigInteger)number, BigIntegerNode::new);
        }
        if (number instanceof Float) {
            return this.convert((Float)number, FloatNode::new);
        }
        return new JacksonPrimitive(NullNode.getInstance());
    }

    @Override
    public JsonEngine.Primitive newJsonPrimitive(Boolean bool) {
        return this.convert(bool, v -> BooleanNode.valueOf(v));
    }

    @Override
    public kong.unirest.core.ObjectMapper getObjectMapper() {
        return this.objm;
    }

    @Override
    public String quote(Object s2) {
        try {
            return this.om.writeValueAsString(s2);
        }
        catch (JsonProcessingException e) {
            throw new JSONException(e);
        }
    }

    private <T> JsonEngine.Primitive convert(T value, ValueSupplier<T> supplier) {
        try {
            if (value == null) {
                return new JacksonPrimitive(NullNode.getInstance());
            }
            return new JacksonPrimitive(supplier.getIt(value));
        }
        catch (JsonProcessingException e) {
            throw new UnirestException(e);
        }
    }

    @FunctionalInterface
    private static interface ValueSupplier<V> {
        public ValueNode getIt(V var1) throws JsonProcessingException;
    }
}

