/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.rest;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kong.unirest.core.Cookie;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.JsonNode;
import kong.unirest.core.Unirest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.RestConstant;
import zowe.client.sdk.rest.ZosmfHeaders;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;

public abstract class ZosmfRequest {
    private static final Logger LOG = LoggerFactory.getLogger(ZosmfRequest.class);
    public static final String X_CSRF_ZOSMF_HEADER_KEY = (String)ZosmfHeaders.HEADERS.get((Object)"X_CSRF_ZOSMF_HEADER").get(0);
    public static final String X_CSRF_ZOSMF_HEADER_VALUE = (String)ZosmfHeaders.HEADERS.get((Object)"X_CSRF_ZOSMF_HEADER").get(1);
    protected final ZosConnection connection;
    protected final Map<String, String> headers = new HashMap<String, String>();
    protected String url;
    protected Cookie cookie;

    public ZosmfRequest(ZosConnection connection) {
        this.connection = connection;
        this.setup();
    }

    private void setup() {
        Unirest.config().reset();
        Unirest.config().enableCookieManagement(false);
        Unirest.config().verifySsl(false);
        this.setStandardHeaders();
    }

    public <T> Response buildResponse(HttpResponse<T> reply) throws ZosmfRequestException {
        Response response;
        int statusCode = reply.getStatus();
        if (statusCode == 0) {
            throw new IllegalStateException("zero number status code return");
        }
        String statusText = reply.getStatusText() == null || reply.getStatusText().isBlank() ? RestConstant.HTTP_STATUS.get(reply.getStatus()) : reply.getStatusText();
        if (statusText == null) {
            statusText = "n\\a";
        }
        if (statusText.toLowerCase().contains("no content")) {
            response = reply.getCookies() != null ? new Response(statusText, statusCode, statusText, reply.getCookies()) : new Response(statusText, statusCode, statusText);
        } else if (reply.getBody() instanceof JsonNode) {
            HttpResponse<T> jsonReply = reply;
            response = reply.getCookies() != null ? (((JsonNode)jsonReply.getBody()).isArray() ? new Response(((JsonNode)jsonReply.getBody()).getArray(), statusCode, statusText, reply.getCookies()) : new Response(((JsonNode)jsonReply.getBody()).getObject(), statusCode, statusText, reply.getCookies())) : (((JsonNode)jsonReply.getBody()).isArray() ? new Response(((JsonNode)jsonReply.getBody()).getArray(), statusCode, statusText) : new Response(((JsonNode)jsonReply.getBody()).getObject(), statusCode, statusText));
        } else if (reply.getBody() instanceof String) {
            HttpResponse<T> stringReply = reply;
            response = reply.getCookies() != null ? new Response(stringReply.getBody(), statusCode, statusText, reply.getCookies()) : new Response(stringReply.getBody(), statusCode, statusText);
        } else if (reply.getBody() instanceof byte[]) {
            HttpResponse<T> byteReply = reply;
            response = reply.getCookies() != null ? new Response(byteReply.getBody(), statusCode, statusText, reply.getCookies()) : new Response(byteReply.getBody(), statusCode, statusText);
        } else {
            LOG.debug("no reply instanceof found");
            Response response2 = response = reply.getCookies() != null ? new Response(null, statusCode, statusText, reply.getCookies()) : new Response(null, statusCode, statusText);
        }
        if (statusCode < 100 || statusCode > 299) {
            throw new ZosmfRequestException(this.httpErrorMsg(response, statusCode), response);
        }
        return response;
    }

    private String httpErrorMsg(Response response, int statusCode) {
        AtomicReference<String> responsePhrase = new AtomicReference<String>();
        response.getResponsePhrase().ifPresent(responsePhrase::set);
        if (responsePhrase.get() instanceof byte[] && ((byte[])responsePhrase.get()).length > 0) {
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])responsePhrase.get()), StandardCharsets.UTF_8);){
                String line;
                BufferedReader br = new BufferedReader(inputStreamReader);
                StringBuilder content = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    content.append(line).append("\n");
                }
                responsePhrase.set(content.substring(0, content.length() - 1));
                br.close();
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }
        String responsePhraseStr = String.valueOf(responsePhrase.get());
        String statusText = response.getStatusText().orElse("n\\a");
        String httpErrMsg = "http status error code: " + statusCode + ", status text: " + statusText;
        if (!statusText.equalsIgnoreCase(responsePhraseStr)) {
            httpErrMsg = httpErrMsg + ", response phrase: " + responsePhraseStr;
        }
        return httpErrMsg;
    }

    public abstract Response executeRequest() throws ZosmfRequestException;

    public abstract void setBody(Object var1);

    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.setStandardHeaders();
        this.RemoveBasicAuth();
        this.headers.putAll(headers);
    }

    public abstract void setStandardHeaders();

    public void setUrl(String url) throws IllegalArgumentException {
        ValidateUtils.checkNullParameter(url == null, "url is null");
        ValidateUtils.checkIllegalParameter(url.isBlank(), "url not specified");
        if (ZosmfRequest.isUrlNotValid(url)) {
            throw new IllegalArgumentException("url is invalid");
        }
        this.url = url;
        LOG.debug(this.url);
    }

    private static boolean isUrlNotValid(String url) {
        try {
            new URL(url).toURI();
            return false;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return true;
        }
    }

    public void setCookie(Cookie cookie) {
        this.cookie = cookie;
        this.RemoveBasicAuth();
    }

    private void RemoveBasicAuth() {
        if (this.cookie == null) {
            LOG.debug("enable basic authorization");
            this.headers.put("Authorization", "Basic " + EncodeUtils.encodeAuthComponent(this.connection));
        } else {
            LOG.debug("disable basic authorization");
            this.headers.remove("Authorization");
        }
    }
}

