/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;

public class CommonJobParams {
    private final Optional<String> jobId;
    private final Optional<String> jobName;
    private final boolean stepData;

    public CommonJobParams(String jobId, String jobName) {
        this.validateParameters(jobId, jobName);
        this.jobId = Optional.of(jobId);
        this.jobName = Optional.of(jobName);
        this.stepData = false;
    }

    public CommonJobParams(String jobId, String jobName, boolean stepData) {
        this.validateParameters(jobId, jobName);
        this.jobId = Optional.of(jobId);
        this.jobName = Optional.of(jobName);
        this.stepData = stepData;
    }

    public Optional<String> getJobId() {
        return this.jobId;
    }

    public Optional<String> getJobName() {
        return this.jobName;
    }

    public boolean isStepData() {
        return this.stepData;
    }

    private void validateParameters(String jobId, String jobName) {
        ValidateUtils.checkNullParameter(jobId == null, "job id is null");
        ValidateUtils.checkIllegalParameter(jobId.isBlank(), "job id not specified");
        ValidateUtils.checkNullParameter(jobName == null, "job name is null");
        ValidateUtils.checkIllegalParameter(jobName.isBlank(), "job name not specified");
    }

    public String toString() {
        return "CommonJobParams{jobId=" + this.jobId + ", jobName=" + this.jobName + "}";
    }
}

