/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfauth.methods;

import kong.unirest.core.Cookie;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosmfauth.response.ZosmfLoginResponse;

public class ZosmfLogin {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public ZosmfLogin(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public ZosmfLogin(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public ZosmfLoginResponse login() throws ZosmfRequestException {
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/services/authenticate";
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.POST_JSON);
        }
        this.request.setUrl(url);
        this.connection.getCookie().ifPresentOrElse(c -> this.request.setCookie((Cookie)c), () -> this.request.setCookie(null));
        this.request.setBody("");
        Response response = this.request.executeRequest();
        return new ZosmfLoginResponse(response, response.getCookies());
    }
}

