/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import java.util.Optional;
import zowe.client.sdk.core.SshConnection;
import zowe.client.sdk.core.ZosConnection;

public final class ValidateUtils {
    private ValidateUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void checkConnection(ZosConnection connection) {
        if (connection == null) {
            throw new IllegalStateException("connection is null");
        }
        if (connection.getCookie().isEmpty()) {
            if (connection.getZosmfPort() == null || connection.getHost() == null || connection.getPassword() == null || connection.getUser() == null || connection.getZosmfPort().isBlank() || connection.getHost().isBlank() || connection.getPassword().isBlank() || connection.getUser().isBlank()) {
                throw new IllegalStateException("one or more connection attribute not defined properly");
            }
        } else if (connection.getZosmfPort() == null || connection.getHost() == null || connection.getZosmfPort().isBlank() || connection.getHost().isBlank()) {
            throw new IllegalStateException("hostname or port connection attribute not defined properly");
        }
    }

    public static void checkIllegalParameter(boolean check, String msg) {
        Optional<String> message = Optional.ofNullable(msg);
        if (check) {
            throw new IllegalArgumentException(message.orElse("empty message specified"));
        }
    }

    public static void checkNullParameter(boolean check, String msg) {
        Optional<String> message = Optional.ofNullable(msg);
        if (check) {
            throw new NullPointerException(message.orElse("empty message specified"));
        }
    }

    public static void checkSshConnection(SshConnection connection) {
        if (connection == null || connection.getHost() == null || connection.getPassword() == null || connection.getUser() == null || connection.getHost().isBlank() || connection.getPassword().isBlank() || connection.getUser().isBlank()) {
            throw new IllegalStateException("SSH connection data not setup properly");
        }
    }
}

