/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.teamconfig;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.teamconfig.exception.TeamConfigException;
import zowe.client.sdk.teamconfig.keytar.KeyTarConfig;
import zowe.client.sdk.teamconfig.model.ConfigContainer;
import zowe.client.sdk.teamconfig.model.Partition;
import zowe.client.sdk.teamconfig.model.Profile;
import zowe.client.sdk.teamconfig.model.ProfileDao;
import zowe.client.sdk.teamconfig.service.KeyTarService;
import zowe.client.sdk.teamconfig.service.TeamConfigService;
import zowe.client.sdk.utility.ValidateUtils;

public class TeamConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TeamConfig.class);
    private final TeamConfigService teamConfigService;
    private final KeyTarService keyTarService;
    private final String BASE_PROFILE_NAME = "base";
    private final Predicate<Profile> isBaseProfile = i -> i.getName().equals("base");
    private final MergeProperties mergeProperties = new MergeProperties();
    private KeyTarConfig keyTarConfig;
    private ConfigContainer teamConfig;

    public TeamConfig(KeyTarService keyTarService, TeamConfigService teamConfigService) throws TeamConfigException {
        this.keyTarService = keyTarService;
        this.teamConfigService = teamConfigService;
        this.config();
    }

    private void config() throws TeamConfigException {
        this.keyTarConfig = this.keyTarService.getKeyTarConfig();
        this.teamConfig = this.teamConfigService.getTeamConfig(this.keyTarConfig);
        LOG.debug("keyTarConfig {}", (Object)this.keyTarConfig);
        LOG.debug("teamConfig {}", (Object)this.teamConfig);
    }

    public ProfileDao getDefaultProfileByName(String name) {
        ValidateUtils.checkNullParameter(name == null, "name is null");
        ValidateUtils.checkIllegalParameter(name.isBlank(), "name not specified");
        Optional<String> defaultName = Optional.ofNullable(this.teamConfig.getDefaults().get(name));
        Predicate<Profile> isProfileName = i -> i.getName().equals(defaultName.orElse(name));
        Optional<Profile> base = this.teamConfig.getProfiles().stream().filter(this.isBaseProfile).findFirst();
        Optional<Profile> target = this.teamConfig.getProfiles().stream().filter(isProfileName).findFirst();
        if (target.isEmpty()) {
            throw new IllegalStateException("No TeamConfig default profile for " + name + " is found.");
        }
        if (!target.get().getType().equalsIgnoreCase(name)) {
            throw new IllegalStateException("No TeamConfig default profile for type " + name + " is found.");
        }
        this.merge(target, base);
        return new ProfileDao(target.get(), this.keyTarConfig.getUserName(), this.keyTarConfig.getPassword(), this.mergeProperties.getHost().orElse(null), this.mergeProperties.getPort().orElse(null));
    }

    public ProfileDao getDefaultProfileFromPartitionByName(String profileName, String partitionName) {
        ValidateUtils.checkNullParameter(profileName == null, "profileName is null");
        ValidateUtils.checkIllegalParameter(profileName.isBlank(), "profileName not specified");
        ValidateUtils.checkNullParameter(partitionName == null, "partitionName is null");
        ValidateUtils.checkIllegalParameter(partitionName.isBlank(), "partitionName not specified");
        Optional<String> defaultName = Optional.ofNullable(this.teamConfig.getDefaults().get(profileName));
        Predicate<Profile> isProfileName = i -> i.getName().equals(defaultName.orElse(profileName));
        Predicate<Partition> isPartitionName = i -> i.getName().equals(partitionName);
        Optional<Profile> base = this.teamConfig.getProfiles().stream().filter(this.isBaseProfile).findFirst();
        Optional<Partition> partition = this.teamConfig.getPartitions().stream().filter(isPartitionName).findFirst();
        if (partition.isEmpty()) {
            throw new IllegalStateException("TeamConfig partition " + partitionName + " not found");
        }
        Optional<Profile> target = partition.get().getProfiles().stream().filter(isProfileName).findFirst();
        if (target.isEmpty()) {
            throw new IllegalStateException("TeamConfig profile " + profileName + " within partition not found");
        }
        Map<String, String> props = partition.get().getProperties();
        this.mergeProperties.setHost(props.get("host"));
        this.mergeProperties.setPort(props.get("port"));
        this.merge(target, base);
        return new ProfileDao(target.get(), this.keyTarConfig.getUserName(), this.keyTarConfig.getPassword(), this.mergeProperties.getHost().orElse(null), this.mergeProperties.getPort().orElse(null));
    }

    private void merge(Optional<Profile> target, Optional<Profile> base) {
        if (target.isEmpty() || base.isEmpty()) {
            return;
        }
        Optional<Map<String, String>> targetProps = Optional.ofNullable(target.get().getProperties());
        Optional<Map<String, String>> baseProps = Optional.ofNullable(base.get().getProperties());
        if (this.mergeProperties.getHost().isEmpty() && targetProps.isPresent()) {
            this.mergeProperties.setHost(targetProps.get().get("host"));
        }
        if (this.mergeProperties.getPort().isEmpty() && targetProps.isPresent()) {
            this.mergeProperties.setPort(targetProps.get().get("port"));
        }
        if (this.mergeProperties.getHost().isEmpty() && baseProps.isPresent()) {
            this.mergeProperties.setHost(baseProps.get().get("host"));
        }
        if (this.mergeProperties.getPort().isEmpty() && baseProps.isPresent()) {
            this.mergeProperties.setPort(baseProps.get().get("port"));
        }
    }

    private static class MergeProperties {
        private Optional<String> host = Optional.empty();
        private Optional<String> port = Optional.empty();

        private MergeProperties() {
        }

        public Optional<String> getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = Optional.ofNullable(host);
        }

        public Optional<String> getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = Optional.ofNullable(port);
        }
    }
}

