/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import kong.unirest.core.Cookie;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PostJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.CreateParams;
import zowe.client.sdk.zosfiles.uss.input.CreateZfsParams;

public class UssCreate {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssCreate(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssCreate(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PostJsonZosmfRequest)) {
            throw new IllegalStateException("POST_JSON request type required");
        }
        this.request = request;
    }

    public Response create(String targetPath, CreateParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(targetPath == null, "targetPath is null");
        ValidateUtils.checkIllegalParameter(targetPath.isBlank(), "targetPath not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        HashMap<String, String> createMap = new HashMap<String, String>();
        createMap.put("type", params.getType().getValue());
        createMap.put("mode", params.getMode());
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.POST_JSON);
        }
        this.request.setUrl(url);
        this.connection.getCookie().ifPresentOrElse(c -> this.request.setCookie((Cookie)c), () -> this.request.setCookie(null));
        this.request.setBody(new JSONObject(createMap).toString());
        return this.request.executeRequest();
    }

    public Response createZfs(String fileSystemName) throws ZosmfRequestException {
        return this.createZfsCommon(fileSystemName, new CreateZfsParams.Builder(10).cylsSec(2).timeout(20).build());
    }

    public Response createZfsCommon(String fileSystemName, CreateZfsParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(fileSystemName == null, "fileSystemName is null");
        ValidateUtils.checkIllegalParameter(fileSystemName.isBlank(), "fileSystemName not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        StringBuilder url = new StringBuilder("https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/mfs/zfs/" + EncodeUtils.encodeURIComponent(fileSystemName));
        params.getTimeout().ifPresent(timeout -> url.append("?timeout=").append(timeout));
        HashMap<String, Object> createZfsMap = new HashMap<String, Object>();
        params.getOwner().ifPresent(owner -> createZfsMap.put("owner", owner));
        params.getGroup().ifPresent(group -> createZfsMap.put("group", group));
        params.getPerms().ifPresent(perms -> createZfsMap.put("perms", perms));
        params.getCylsPri().ifPresent(cylsPri -> createZfsMap.put("cylsPri", cylsPri));
        params.getCylsSec().ifPresent(cs -> createZfsMap.put("cylsSec", cs));
        params.getStorageClass().ifPresent(sc -> createZfsMap.put("storageClass", sc));
        params.getManagementClass().ifPresent(mc -> createZfsMap.put("managementClass", mc));
        params.getDataClass().ifPresent(dc -> createZfsMap.put("dataClass", dc));
        if (params.getVolumes().size() == 1) {
            createZfsMap.put("volumes", "[\"" + params.getVolumes().get(0) + "\"]");
        }
        if (params.getVolumes().size() > 1) {
            StringBuilder volumesStr = new StringBuilder();
            params.getVolumes().forEach(volume -> volumesStr.append("\"").append((String)volume).append("\","));
            createZfsMap.put("volumes", "[" + volumesStr.substring(0, volumesStr.length() - 1) + "]");
        }
        createZfsMap.put("JSONversion", 1);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.POST_JSON);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        params.getSystem().ifPresent(system -> headers.put("X-IBM-Target-System", (String)system));
        this.request.setHeaders(headers);
        this.request.setUrl(url.toString());
        this.connection.getCookie().ifPresentOrElse(c -> this.request.setCookie((Cookie)c), () -> this.request.setCookie(null));
        this.request.setBody(new JSONObject(createZfsMap).toString());
        return this.request.executeRequest();
    }
}

