/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.rest;

import kong.unirest.core.HttpRequestWithBody;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.JsonNode;
import kong.unirest.core.Unirest;
import kong.unirest.core.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class PostJsonZosmfRequest
extends ZosmfRequest {
    private static final Logger LOG = LoggerFactory.getLogger(PostJsonZosmfRequest.class);
    private String body;

    public PostJsonZosmfRequest(ZosConnection connection) {
        super(connection);
    }

    @Override
    public Response executeRequest() throws ZosmfRequestException {
        HttpResponse<JsonNode> reply;
        ValidateUtils.checkNullParameter(this.url == null, "url is null");
        ValidateUtils.checkNullParameter(this.body == null, "body is null");
        try {
            reply = this.cookie != null ? ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post(this.url).cookie(this.cookie)).headers(this.headers)).body(this.body).asJson() : ((HttpRequestWithBody)Unirest.post(this.url).headers(this.headers)).body(this.body).asJson();
        }
        catch (UnirestException e) {
            throw new ZosmfRequestException(e.getMessage(), e);
        }
        return this.buildResponse(reply);
    }

    @Override
    public void setBody(Object body) {
        this.body = (String)body;
        LOG.debug(this.body);
    }

    @Override
    public void setStandardHeaders() {
        this.headers.put("Authorization", "Basic " + EncodeUtils.encodeAuthComponent(this.connection));
        this.headers.put("Content-Type", "application/json");
        this.headers.put(X_CSRF_ZOSMF_HEADER_KEY, X_CSRF_ZOSMF_HEADER_VALUE);
    }
}

