/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.HashMap;
import kong.unirest.core.Cookie;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.ModifyJobParams;
import zowe.client.sdk.zosjobs.response.Job;

public class JobCancel {
    private static final Logger LOG = LoggerFactory.getLogger(JobCancel.class);
    private final ZosConnection connection;
    private ZosmfRequest request;

    public JobCancel(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public JobCancel(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response cancel(String jobName, String jobId, String version) throws ZosmfRequestException {
        return this.cancelCommon(new ModifyJobParams.Builder(jobName, jobId).version(version).build());
    }

    public Response cancelByJob(Job job, String version) throws ZosmfRequestException {
        String jobName = job.getJobName().orElse("");
        String jobId = job.getJobId().orElse("");
        return this.cancelCommon(new ModifyJobParams.Builder(jobName, jobId).version(version).build());
    }

    public Response cancelCommon(ModifyJobParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + params.getJobName().get() + "/" + params.getJobId().get();
        String version = params.getVersion().orElse("1.0");
        if ("1.0".equals(version)) {
            LOG.debug("version 1.0 specified which will result in asynchronous processing for the request");
        } else if ("2.0".equals(version)) {
            LOG.debug("version 2.0 specified which will result in synchronous processing for the request");
        } else {
            throw new IllegalArgumentException("invalid version specified");
        }
        HashMap<String, String> cancelMap = new HashMap<String, String>();
        cancelMap.put("request", "cancel");
        cancelMap.put("version", version);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.connection.getCookie().ifPresentOrElse(c -> this.request.setCookie((Cookie)c), () -> this.request.setCookie(null));
        this.request.setBody(new JSONObject(cancelMap).toString());
        return this.request.executeRequest();
    }
}

