/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfinfo.response;

import java.util.Optional;
import java.util.OptionalLong;
import zowe.client.sdk.zosmfinfo.response.DefinedSystem;

public class ZosmfSystemsResponse {
    private final OptionalLong numRows;
    private final Optional<DefinedSystem[]> definedSystems;

    private ZosmfSystemsResponse(Builder builder) {
        this.numRows = builder.numRows == null ? OptionalLong.empty() : OptionalLong.of(builder.numRows);
        this.definedSystems = Optional.ofNullable(builder.definedSystems);
    }

    public Optional<DefinedSystem[]> getDefinedSystems() {
        return this.definedSystems;
    }

    public OptionalLong getNumRows() {
        return this.numRows;
    }

    public String toString() {
        return "ZosmfSystemsResponse{numRows=" + this.numRows + ", definedSystems=" + this.definedSystems + "}";
    }

    public static class Builder {
        private Long numRows;
        private DefinedSystem[] definedSystems;

        public Builder definedSystems(DefinedSystem[] definedSystems) {
            this.definedSystems = definedSystems;
            return this;
        }

        public Builder numRows(Long numRows) {
            this.numRows = numRows;
            return this;
        }

        public ZosmfSystemsResponse build() {
            return new ZosmfSystemsResponse(this);
        }
    }
}

