/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import zowe.client.sdk.utility.ValidateUtils;

public class CreateZfsParams {
    private final OptionalInt owner;
    private final OptionalInt group;
    private final OptionalInt perms;
    private final OptionalInt cylsPri;
    private final OptionalInt cylsSec;
    private final Optional<String> storageClass;
    private final Optional<String> managementClass;
    private final Optional<String> dataClass;
    private final List<String> volumes;
    private final OptionalInt timeout;
    private final Optional<String> system;

    private CreateZfsParams(Builder builder) {
        this.owner = builder.owner == null ? OptionalInt.empty() : OptionalInt.of(builder.owner);
        this.group = builder.group == null ? OptionalInt.empty() : OptionalInt.of(builder.group);
        this.perms = builder.perms == null ? OptionalInt.empty() : OptionalInt.of(builder.perms);
        this.cylsPri = builder.cylsPri == null ? OptionalInt.empty() : OptionalInt.of(builder.cylsPri);
        this.cylsSec = builder.cylsSec == null ? OptionalInt.empty() : OptionalInt.of(builder.cylsSec);
        this.storageClass = Optional.ofNullable(builder.storageClass);
        this.managementClass = Optional.ofNullable(builder.managementClass);
        this.dataClass = Optional.ofNullable(builder.dataClass);
        this.volumes = builder.volumes;
        this.timeout = builder.timeout == null ? OptionalInt.empty() : OptionalInt.of(builder.timeout);
        this.system = Optional.ofNullable(builder.system);
    }

    public OptionalInt getOwner() {
        return this.owner;
    }

    public OptionalInt getGroup() {
        return this.group;
    }

    public OptionalInt getPerms() {
        return this.perms;
    }

    public OptionalInt getCylsPri() {
        return this.cylsPri;
    }

    public OptionalInt getCylsSec() {
        return this.cylsSec;
    }

    public Optional<String> getStorageClass() {
        return this.storageClass;
    }

    public Optional<String> getManagementClass() {
        return this.managementClass;
    }

    public Optional<String> getDataClass() {
        return this.dataClass;
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public OptionalInt getTimeout() {
        return this.timeout;
    }

    public Optional<String> getSystem() {
        return this.system;
    }

    public String toString() {
        return "CreateZfsParams{owner=" + this.owner + ", group=" + this.group + ", perms=" + this.perms + ", cylsPri=" + this.cylsPri + ", cylsSec=" + this.cylsSec + ", storageClass=" + this.storageClass + ", managementClass=" + this.managementClass + ", dataClass=" + this.dataClass + ", volumes=" + this.volumes + ", timeout=" + this.timeout + ", system=" + this.system + "}";
    }

    public static class Builder {
        private Integer owner;
        private Integer group;
        private Integer perms;
        private final Integer cylsPri;
        private Integer cylsSec;
        private String storageClass;
        private String managementClass;
        private String dataClass;
        private List<String> volumes = new ArrayList<String>();
        private Integer timeout;
        private String system;

        public Builder(Integer cylsPri) {
            ValidateUtils.checkNullParameter(cylsPri == null, "cylsPri is null");
            ValidateUtils.checkIllegalParameter(cylsPri <= 0, "specify cylsPri greater than 0");
            this.cylsPri = cylsPri;
        }

        public Builder owner(Integer owner) {
            this.owner = owner;
            return this;
        }

        public Builder group(Integer group) {
            this.group = group;
            return this;
        }

        public Builder perms(Integer perms) {
            this.perms = perms;
            return this;
        }

        public Builder cylsSec(Integer cylsSec) {
            this.cylsSec = cylsSec;
            return this;
        }

        public Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder managementClass(String managementClass) {
            this.managementClass = managementClass;
            return this;
        }

        public Builder dataClass(String dataClass) {
            this.dataClass = dataClass;
            return this;
        }

        public Builder volumes(List<String> volumes) {
            this.volumes = volumes;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder system(String system) {
            this.system = system;
            return this;
        }

        public CreateZfsParams build() {
            return new CreateZfsParams(this);
        }
    }
}

