/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;

public final class JsonParserUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JsonParserUtil.class);
    private static final String PARSE_ERROR_MSG = "json response parse error";

    private JsonParserUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static JSONObject parse(String item) throws ZosmfRequestException {
        try {
            return (JSONObject)new JSONParser().parse(item);
        }
        catch (ParseException e) {
            LOG.debug(PARSE_ERROR_MSG, (Throwable)e);
            throw new ZosmfRequestException(e.getMessage(), e);
        }
    }

    public static JSONArray parseArray(String item) throws ZosmfRequestException {
        try {
            return (JSONArray)new JSONParser().parse(item);
        }
        catch (ParseException e) {
            LOG.debug(PARSE_ERROR_MSG, (Throwable)e);
            throw new ZosmfRequestException(e.getMessage(), e);
        }
    }
}

