/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.response;

import java.util.Optional;
import java.util.OptionalLong;

public class Member {
    private final Optional<String> member;
    private final OptionalLong vers;
    private final OptionalLong mod;
    private final Optional<String> c4date;
    private final Optional<String> m4date;
    private final OptionalLong cnorc;
    private final OptionalLong inorc;
    private final OptionalLong mnorc;
    private final Optional<String> mtime;
    private final Optional<String> msec;
    private final Optional<String> user;
    private final Optional<String> sclm;

    private Member(Builder builder) {
        this.member = Optional.ofNullable(builder.member);
        this.vers = builder.vers == null ? OptionalLong.empty() : OptionalLong.of(builder.vers);
        this.mod = builder.mod == null ? OptionalLong.empty() : OptionalLong.of(builder.mod);
        this.c4date = Optional.ofNullable(builder.c4date);
        this.m4date = Optional.ofNullable(builder.m4date);
        this.cnorc = builder.cnorc == null ? OptionalLong.empty() : OptionalLong.of(builder.cnorc);
        this.inorc = builder.inorc == null ? OptionalLong.empty() : OptionalLong.of(builder.inorc);
        this.mnorc = builder.mnorc == null ? OptionalLong.empty() : OptionalLong.of(builder.mnorc);
        this.mtime = Optional.ofNullable(builder.mtime);
        this.msec = Optional.ofNullable(builder.msec);
        this.user = Optional.ofNullable(builder.user);
        this.sclm = Optional.ofNullable(builder.sclm);
    }

    public Optional<String> getMember() {
        return this.member;
    }

    public OptionalLong getVers() {
        return this.vers;
    }

    public OptionalLong getMod() {
        return this.mod;
    }

    public Optional<String> getC4date() {
        return this.c4date;
    }

    public Optional<String> getM4date() {
        return this.m4date;
    }

    public OptionalLong getCnorc() {
        return this.cnorc;
    }

    public OptionalLong getInorc() {
        return this.inorc;
    }

    public OptionalLong getMnorc() {
        return this.mnorc;
    }

    public Optional<String> getMtime() {
        return this.mtime;
    }

    public Optional<String> getMsec() {
        return this.msec;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public Optional<String> getSclm() {
        return this.sclm;
    }

    public String toString() {
        return "Member{member=" + this.member + ", vers=" + this.vers + ", mod=" + this.mod + ", c4date=" + this.c4date + ", m4date=" + this.m4date + ", cnorc=" + this.cnorc + ", inorc=" + this.inorc + ", mnorc=" + this.mnorc + ", mtime=" + this.mtime + ", msec=" + this.msec + ", user=" + this.user + ", sclm=" + this.sclm + "}";
    }

    public static class Builder {
        private String member;
        private Long vers;
        private Long mod;
        private String c4date;
        private String m4date;
        private Long cnorc;
        private Long inorc;
        private Long mnorc;
        private String mtime;
        private String msec;
        private String user;
        private String sclm;

        public Builder member(String member) {
            this.member = member;
            return this;
        }

        public Builder vers(Long vers) {
            this.vers = vers;
            return this;
        }

        public Builder mod(Long mod) {
            this.mod = mod;
            return this;
        }

        public Builder c4date(String c4date) {
            this.c4date = c4date;
            return this;
        }

        public Builder m4date(String m4date) {
            this.m4date = m4date;
            return this;
        }

        public Builder cnorc(Long cnorc) {
            this.cnorc = cnorc;
            return this;
        }

        public Builder inorc(Long inorc) {
            this.inorc = inorc;
            return this;
        }

        public Builder mnorc(Long mnorc) {
            this.mnorc = mnorc;
            return this;
        }

        public Builder mtime(String mtime) {
            this.mtime = mtime;
            return this;
        }

        public Builder msec(String msec) {
            this.msec = msec;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder sclm(String sclm) {
            this.sclm = sclm;
            return this;
        }

        public Member build() {
            return new Member(this);
        }
    }
}

