/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.DeleteJsonZosmfRequest;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.GetStreamZosmfRequest;
import zowe.client.sdk.rest.GetTextZosmfRequest;
import zowe.client.sdk.rest.PostJsonZosmfRequest;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.PutStreamZosmfRequest;
import zowe.client.sdk.rest.PutTextZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.type.ZosmfRequestType;

public final class ZosmfRequestFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ZosmfRequestFactory.class);

    private ZosmfRequestFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static ZosmfRequest buildRequest(ZosConnection connection, ZosmfRequestType type) {
        ZosmfRequest request;
        LOG.debug(type.name());
        switch (type) {
            case GET_JSON: {
                request = new GetJsonZosmfRequest(connection);
                break;
            }
            case PUT_JSON: {
                request = new PutJsonZosmfRequest(connection);
                break;
            }
            case POST_JSON: {
                request = new PostJsonZosmfRequest(connection);
                break;
            }
            case DELETE_JSON: {
                request = new DeleteJsonZosmfRequest(connection);
                break;
            }
            case GET_TEXT: {
                request = new GetTextZosmfRequest(connection);
                break;
            }
            case PUT_TEXT: {
                request = new PutTextZosmfRequest(connection);
                break;
            }
            case GET_STREAM: {
                request = new GetStreamZosmfRequest(connection);
                break;
            }
            case PUT_STREAM: {
                request = new PutStreamZosmfRequest(connection);
                break;
            }
            default: {
                throw new IllegalStateException("no valid ZoweRequestType type specified");
            }
        }
        return request;
    }
}

