/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.lifecycle;

import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PostJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.input.StartTsoParams;
import zowe.client.sdk.zostso.lifecycle.SendTso;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;
import zowe.client.sdk.zostso.response.CollectedResponses;
import zowe.client.sdk.zostso.response.StartStopResponses;
import zowe.client.sdk.zostso.service.TsoResponseService;

public class StartTso {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public StartTso(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public StartTso(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PostJsonZosmfRequest)) {
            throw new IllegalStateException("POST_JSON request type required");
        }
        this.request = request;
    }

    private String getResourcesQuery(StartTsoParams params) {
        String query = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort();
        query = query + "/zosmf/tsoApp/tso?";
        query = query + "acct=" + params.account.orElseThrow(() -> new IllegalStateException("account num not specified")) + "&";
        query = query + "proc=" + params.logonProcedure.orElse("IZUFPROC") + "&";
        query = query + "chset=" + params.characterSet.orElse("697") + "&";
        query = query + "cpage=" + params.codePage.orElse("1047") + "&";
        query = query + "rows=" + params.rows.orElse("24") + "&";
        query = query + "cols=" + params.columns.orElse("80") + "&";
        query = query + "rsize=" + params.regionSize.orElse("4096");
        return query;
    }

    private StartTsoParams setDefaultAddressSpaceParams(StartTsoParams params, String accountNumber) {
        if (params == null) {
            params = new StartTsoParams();
        }
        String proc = params.getLogonProcedure().orElse("IZUFPROC");
        String chset = params.getCharacterSet().orElse("697");
        String cpage = params.getCodePage().orElse("1047");
        String rowNum = params.getRows().orElse("24");
        String cols = params.getColumns().orElse("80");
        String rSize = params.getRegionSize().orElse("4096");
        return new StartTsoParams(proc, chset, cpage, rowNum, cols, accountNumber, rSize);
    }

    public StartStopResponses start(String accountNumber, StartTsoParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(accountNumber == null, "accountNumber is null");
        ValidateUtils.checkIllegalParameter(accountNumber.isBlank(), "accountNumber not specified");
        StartTsoParams customParams = params == null ? this.setDefaultAddressSpaceParams(null, EncodeUtils.encodeURIComponent(accountNumber)) : this.setDefaultAddressSpaceParams(params, EncodeUtils.encodeURIComponent(accountNumber));
        ZosmfTsoResponse zosmfResponse = this.startCommon(customParams);
        CollectedResponses collectedResponses = null;
        if (zosmfResponse.getServletKey().isPresent()) {
            SendTso sendTso = new SendTso(this.connection);
            collectedResponses = sendTso.getAllResponses(zosmfResponse);
        }
        return new StartStopResponses(zosmfResponse, collectedResponses);
    }

    public ZosmfTsoResponse startCommon(StartTsoParams commandParams) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(commandParams == null, "commandParams is null");
        String url = this.getResourcesQuery(commandParams);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.POST_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody("");
        return new TsoResponseService(this.request.executeRequest()).getZosmfTsoResponse();
    }
}

