/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfauth.methods;

import kong.unirest.core.Cookie;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.DeleteJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ValidateUtils;

public class ZosmfLogout {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public ZosmfLogout(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public ZosmfLogout(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof DeleteJsonZosmfRequest)) {
            throw new IllegalStateException("DELETE_JSON request type required");
        }
        this.request = request;
    }

    public Response logout(Cookie token) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(token == null, "token is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/services/authenticate";
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.DELETE_JSON);
        }
        this.request.setUrl(url);
        return this.request.executeRequest();
    }
}

