/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JsonEngine;
import kong.unirest.jackson.JacksonArray;
import kong.unirest.jackson.JacksonObject;
import kong.unirest.jackson.JacksonPrimitive;

class JacksonElement<T extends JsonNode>
implements JsonEngine.Element {
    protected T element;

    JacksonElement(T element) {
        this.element = element;
    }

    static JsonEngine.Element wrap(JsonNode node) {
        if (node == null || node.isNull()) {
            return new JacksonPrimitive(NullNode.getInstance());
        }
        if (node.isArray()) {
            return new JacksonArray((ArrayNode)node);
        }
        if (node.isObject()) {
            return new JacksonObject((ObjectNode)node);
        }
        if (node.isValueNode()) {
            return new JacksonPrimitive((ValueNode)node);
        }
        return new JacksonPrimitive(NullNode.getInstance());
    }

    @Override
    public JsonEngine.Object getAsJsonObject() {
        if (((JsonNode)this.element).isObject()) {
            return new JacksonObject((ObjectNode)this.element);
        }
        throw new IllegalStateException("Not an object");
    }

    @Override
    public boolean isJsonNull() {
        return this.element instanceof NullNode;
    }

    @Override
    public JsonEngine.Primitive getAsJsonPrimitive() {
        return new JacksonPrimitive((ValueNode)this.element);
    }

    @Override
    public JsonEngine.Array getAsJsonArray() {
        if (!((JsonNode)this.element).isArray()) {
            throw new IllegalStateException("Not an Array");
        }
        return new JacksonArray((ArrayNode)this.element);
    }

    @Override
    public float getAsFloat() {
        if (!((JsonNode)this.element).isFloat()) {
            throw new NumberFormatException("not a float");
        }
        return ((JsonNode)this.element).floatValue();
    }

    @Override
    public double getAsDouble() {
        if (!((JsonNode)this.element).isNumber()) {
            throw new NumberFormatException("not a double");
        }
        return ((JsonNode)this.element).asDouble();
    }

    @Override
    public String getAsString() {
        return ((JsonNode)this.element).asText();
    }

    @Override
    public long getAsLong() {
        if (!((JsonNode)this.element).isLong() && !((JsonNode)this.element).isIntegralNumber()) {
            throw new NumberFormatException("not a long");
        }
        return ((JsonNode)this.element).asLong();
    }

    @Override
    public int getAsInt() {
        if (!((JsonNode)this.element).isIntegralNumber()) {
            throw new NumberFormatException("Not a number");
        }
        return ((JsonNode)this.element).asInt();
    }

    @Override
    public boolean getAsBoolean() {
        return ((JsonNode)this.element).asBoolean();
    }

    @Override
    public BigInteger getAsBigInteger() {
        if (!((JsonNode)this.element).isIntegralNumber()) {
            throw new NumberFormatException("Not a integer");
        }
        return ((JsonNode)this.element).bigIntegerValue();
    }

    @Override
    public BigDecimal getAsBigDecimal() {
        if (!((JsonNode)this.element).isNumber()) {
            throw new NumberFormatException("Not a decimal");
        }
        return ((JsonNode)this.element).decimalValue();
    }

    @Override
    public JsonEngine.Primitive getAsPrimitive() {
        if (((JsonNode)this.element).isValueNode()) {
            return new JacksonPrimitive((ValueNode)this.element);
        }
        throw new JSONException("Not a value type");
    }

    @Override
    public boolean isJsonArray() {
        return ((JsonNode)this.element).isArray();
    }

    @Override
    public boolean isJsonPrimitive() {
        return ((JsonNode)this.element).isValueNode();
    }

    @Override
    public boolean isJsonObject() {
        return ((JsonNode)this.element).isObject();
    }

    @Override
    public <T> T getEngineElement() {
        return this.element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonElement that = (JacksonElement)o;
        return Objects.equals(this.element, that.element);
    }

    public int hashCode() {
        return Objects.hash(this.element);
    }
}

