/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import java.util.Optional;
import zowe.client.sdk.core.AuthType;
import zowe.client.sdk.core.SshConnection;
import zowe.client.sdk.core.ZosConnection;

public final class ValidateUtils {
    private ValidateUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void checkConnection(ZosConnection connection) {
        if (connection == null) {
            throw new IllegalStateException("connection is null");
        }
        String errMsg = "required connection attribute(s) missing for " + connection.getAuthType() + " authentication";
        if (connection.getAuthType().equals((Object)AuthType.BASIC) ? connection.getZosmfPort() == null || connection.getHost() == null || connection.getPassword() == null || connection.getUser() == null || connection.getZosmfPort().isBlank() || connection.getHost().isBlank() || connection.getPassword().isBlank() || connection.getUser().isBlank() : (connection.getAuthType().equals((Object)AuthType.TOKEN) ? connection.getZosmfPort() == null || connection.getHost() == null || connection.getToken() == null || connection.getZosmfPort().isBlank() || connection.getHost().isBlank() : connection.getAuthType().equals((Object)AuthType.SSL) && (connection.getZosmfPort() == null || connection.getHost() == null || connection.getCertFilePath() == null || connection.getZosmfPort().isBlank() || connection.getHost().isBlank() || connection.getCertFilePath().isBlank()))) {
            throw new IllegalStateException(errMsg);
        }
    }

    public static void checkIllegalParameter(boolean check, String msg) {
        Optional<String> message = Optional.ofNullable(msg);
        if (check) {
            throw new IllegalArgumentException(message.orElse("empty message specified"));
        }
    }

    public static void checkNullParameter(boolean check, String msg) {
        Optional<String> message = Optional.ofNullable(msg);
        if (check) {
            throw new NullPointerException(message.orElse("empty message specified"));
        }
    }

    public static void checkSshConnection(SshConnection connection) {
        if (connection == null || connection.getHost() == null || connection.getPassword() == null || connection.getUser() == null || connection.getHost().isBlank() || connection.getPassword().isBlank() || connection.getUser().isBlank()) {
            throw new IllegalStateException("SSH connection data not setup properly");
        }
    }
}

