/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.ChangeTagParams;
import zowe.client.sdk.zosfiles.uss.types.ChangeTagAction;
import zowe.client.sdk.zosfiles.uss.types.ChangeTagType;

public class UssChangeTag {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssChangeTag(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssChangeTag(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response binary(String fileNamePath) throws ZosmfRequestException {
        return this.changeCommon(fileNamePath, new ChangeTagParams.Builder().action(ChangeTagAction.SET).type(ChangeTagType.BINARY).build());
    }

    public Response text(String fileNamePath, String codeSet) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(codeSet == null, "codeSet is null");
        ValidateUtils.checkIllegalParameter(codeSet.isBlank(), "codeSet not specified");
        return this.changeCommon(fileNamePath, new ChangeTagParams.Builder().action(ChangeTagAction.SET).type(ChangeTagType.TEXT).codeset(codeSet).build());
    }

    public Response remove(String fileNamePath) throws ZosmfRequestException {
        return this.changeCommon(fileNamePath, new ChangeTagParams.Builder().action(ChangeTagAction.REMOVE).build());
    }

    public Response get(String fileNamePath) throws ZosmfRequestException {
        return this.changeCommon(fileNamePath, new ChangeTagParams.Builder().action(ChangeTagAction.LIST).build());
    }

    public Response changeCommon(String fileNamePath, ChangeTagParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(fileNamePath == null, "fileNamePath is null");
        ValidateUtils.checkIllegalParameter(fileNamePath.isBlank(), "fileNamePath not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getAction().isEmpty(), "action not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(fileNamePath));
        HashMap<String, String> changeTagMap = new HashMap<String, String>();
        changeTagMap.put("request", "chtag");
        changeTagMap.put("action", params.getAction().get().getValue());
        params.getType().ifPresent(type -> changeTagMap.put("type", type.getValue()));
        params.getCodeset().ifPresent(codeset -> changeTagMap.put("codeset", (String)codeset));
        if (!params.isRecursive()) {
            changeTagMap.put("recursive", "false");
        }
        params.getLinks().ifPresent(links -> changeTagMap.put("links", links.getValue()));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(changeTagMap).toString());
        return this.request.executeRequest();
    }
}

