/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutStreamZosmfRequest;
import zowe.client.sdk.rest.PutTextZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.WriteParams;

public class UssWrite {
    private static final Logger LOG = LoggerFactory.getLogger(UssWrite.class);
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssWrite(ZosConnection connection) {
        this.connection = connection;
    }

    public UssWrite(ZosConnection connection, ZosmfRequest request) {
        this.connection = connection;
        this.request = request;
    }

    public Response writeText(String fileNamePath, String content) throws ZosmfRequestException {
        return this.writeCommon(fileNamePath, new WriteParams.Builder().textContent(content).build());
    }

    public Response writeBinary(String fileNamePath, byte[] content) throws ZosmfRequestException {
        return this.writeCommon(fileNamePath, new WriteParams.Builder().binaryContent(content).binary(true).build());
    }

    public Response writeCommon(String fileNamePath, WriteParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(fileNamePath == null, "fileNamePath is null");
        ValidateUtils.checkIllegalParameter(fileNamePath.isBlank(), "fileNamePath not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(fileNamePath));
        HashMap<String, String> headers = new HashMap<String, String>();
        if (params.isBinary()) {
            headers.put("X-IBM-Data-Type", "binary;");
            if (params.getBinaryContent().isEmpty()) {
                LOG.debug("binaryContent is empty");
            }
            if (this.request == null || !(this.request instanceof PutStreamZosmfRequest)) {
                this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_STREAM);
            }
            this.request.setBody(params.getBinaryContent().orElse(new byte[0]));
        } else {
            StringBuilder textHeader = new StringBuilder("text");
            params.getFileEncoding().ifPresent(encoding -> textHeader.append(";fileEncoding=").append((String)encoding));
            if (params.isCrlf()) {
                textHeader.append(";crlf=true");
            }
            textHeader.append(";");
            headers.put("X-IBM-Data-Type", textHeader.toString());
            if (params.getTextContent().isEmpty()) {
                LOG.debug("textContent is empty");
            }
            if (this.request == null || !(this.request instanceof PutTextZosmfRequest)) {
                this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_TEXT);
            }
            this.request.setBody(params.getTextContent().orElse(""));
        }
        this.request.setHeaders(headers);
        this.request.setUrl(url);
        return this.request.executeRequest();
    }
}

