/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.core;

import java.util.Objects;
import java.util.Optional;
import kong.unirest.core.Cookie;
import zowe.client.sdk.core.AuthType;

public class ZosConnection {
    private final String host;
    private final String zosmfPort;
    private final AuthType authType;
    private String user;
    private String password;
    private Cookie token;
    private String certFilePath;
    private String certPassword;
    private Optional<String> basePath = Optional.empty();
    private boolean isSecure = true;

    ZosConnection(String host, String zosmfPort, AuthType authType) {
        this.host = host;
        this.zosmfPort = zosmfPort;
        this.authType = authType;
    }

    public String getHost() {
        return this.host;
    }

    public String getZosmfPort() {
        return this.zosmfPort;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    void setPassword(String password) {
        this.password = password;
    }

    public Cookie getToken() {
        return this.token;
    }

    void setToken(Cookie token) {
        this.token = token;
    }

    public String getCertFilePath() {
        return this.certFilePath;
    }

    void setCertFilePath(String certFilePath) {
        this.certFilePath = certFilePath;
    }

    public String getCertPassword() {
        return this.certPassword;
    }

    void setCertPassword(String certPassword) {
        this.certPassword = certPassword;
    }

    public void setBasePath(String basePath) {
        this.basePath = Optional.ofNullable(basePath);
    }

    public Optional<String> getBasePath() {
        return this.basePath;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ZosConnection other = (ZosConnection)obj;
        if (this.authType == AuthType.BASIC) {
            return Objects.equals(this.host, other.host) && Objects.equals(this.zosmfPort, other.zosmfPort) && Objects.equals(this.user, other.user) && Objects.equals(this.password, other.password) && Objects.equals(this.basePath, other.basePath) && this.isSecure == other.isSecure;
        }
        if (this.authType == AuthType.TOKEN) {
            if (this.user != null && !this.user.isBlank()) {
                return Objects.equals(this.host, other.host) && Objects.equals(this.zosmfPort, other.zosmfPort) && Objects.equals(this.user, other.user) && Objects.equals(this.token.getValue(), other.token.getValue()) && Objects.equals(this.basePath, other.basePath) && this.isSecure == other.isSecure;
            }
            return Objects.equals(this.host, other.host) && Objects.equals(this.zosmfPort, other.zosmfPort) && Objects.equals(this.token.getValue(), other.token.getValue()) && Objects.equals(this.basePath, other.basePath) && this.isSecure == other.isSecure;
        }
        if (this.authType == AuthType.SSL) {
            if (this.user != null && !this.user.isBlank()) {
                return Objects.equals(this.host, other.host) && Objects.equals(this.zosmfPort, other.zosmfPort) && Objects.equals(this.user, other.user) && Objects.equals(this.certPassword, other.certPassword) && Objects.equals(this.certFilePath, other.certFilePath) && Objects.equals(this.basePath, other.basePath) && this.isSecure == other.isSecure;
            }
            return Objects.equals(this.host, other.host) && Objects.equals(this.zosmfPort, other.zosmfPort) && Objects.equals(this.certPassword, other.certPassword) && Objects.equals(this.certFilePath, other.certFilePath) && Objects.equals(this.basePath, other.basePath) && this.isSecure == other.isSecure;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.zosmfPort, this.user, this.password, this.certPassword, this.token, this.certFilePath, this.isSecure, this.basePath);
    }
}

