/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.teamconfig.service;

import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.teamconfig.exception.TeamConfigException;
import zowe.client.sdk.teamconfig.keytar.KeyTarConfig;
import zowe.client.sdk.teamconfig.model.ConfigContainer;
import zowe.client.sdk.teamconfig.model.Partition;
import zowe.client.sdk.teamconfig.model.Profile;
import zowe.client.sdk.teamconfig.types.SectionType;
import zowe.client.sdk.utility.ValidateUtils;

public class TeamConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(TeamConfigService.class);

    private Partition getPartition(String name, JSONObject jsonObject) {
        Set keyObjs = jsonObject.keySet();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        Map<String, String> properties = new HashMap<String, String>();
        LOG.debug("partition found name {} containing {}:", (Object)name, (Object)jsonObject);
        for (String keyObj : keyObjs) {
            if (SectionType.PROFILES.getValue().equals(keyObj)) {
                JSONObject jsonProfileObj = (JSONObject)jsonObject.get(SectionType.PROFILES.getValue());
                Set jsonProfileKeys = jsonProfileObj.keySet();
                for (String profileKeyVal : jsonProfileKeys) {
                    JSONObject profileTypeJsonObj = (JSONObject)jsonProfileObj.get(profileKeyVal);
                    profiles.add(new Profile(profileKeyVal, (String)profileTypeJsonObj.get("type"), (JSONObject)profileTypeJsonObj.get("properties"), (JSONArray)profileTypeJsonObj.get("secure")));
                }
                continue;
            }
            if (!"properties".equalsIgnoreCase(keyObj)) continue;
            properties = (Map)JsonParseFactory.buildParser(ParseType.PROPS).parseResponse(jsonObject.get(keyObj));
        }
        return new Partition(name, properties, profiles);
    }

    public ConfigContainer getTeamConfig(KeyTarConfig config) throws TeamConfigException {
        Object obj;
        ValidateUtils.checkNullParameter(config == null, "config is null");
        JSONParser parser = new JSONParser();
        try {
            obj = parser.parse(new FileReader(config.getLocation()));
        }
        catch (IOException | ParseException e) {
            throw new TeamConfigException("Error reading zowe global team configuration file", e);
        }
        return this.parseJson((JSONObject)obj);
    }

    private boolean isPartition(Set<String> profileKeyObj) {
        Iterator<String> itr = profileKeyObj.iterator();
        if (itr.hasNext()) {
            String keyVal = itr.next();
            return SectionType.PROFILES.getValue().equals(keyVal);
        }
        throw new IllegalStateException("TeamConfig profile type detail missing in profile section.");
    }

    private ConfigContainer parseJson(JSONObject jsonObj) {
        String schema = null;
        Boolean autoStore = null;
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        HashMap<String, String> defaults = new HashMap<String, String>();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        Set jsonSectionKeys = jsonObj.keySet();
        for (String keySectionVal : jsonSectionKeys) {
            if (SectionType.$SCHEMA.getValue().equals(keySectionVal)) {
                schema = (String)jsonObj.get(SectionType.$SCHEMA.getValue());
                continue;
            }
            if (SectionType.PROFILES.getValue().equals(keySectionVal)) {
                JSONObject jsonProfileObj = (JSONObject)jsonObj.get(SectionType.PROFILES.getValue());
                Set jsonProfileKeys = jsonProfileObj.keySet();
                for (String profileKeyVal : jsonProfileKeys) {
                    JSONObject profileTypeJsonObj = (JSONObject)jsonProfileObj.get(profileKeyVal);
                    Set<String> isEmbeddedKeyProfile = profileTypeJsonObj.keySet();
                    if (this.isPartition(isEmbeddedKeyProfile)) {
                        partitions.add(this.getPartition(profileKeyVal, profileTypeJsonObj));
                        continue;
                    }
                    profiles.add(new Profile(profileKeyVal, (String)profileTypeJsonObj.get("type"), (JSONObject)profileTypeJsonObj.get("properties"), (JSONArray)profileTypeJsonObj.get("secure")));
                }
                continue;
            }
            if (SectionType.DEFAULTS.getValue().equals(keySectionVal)) {
                JSONObject keyValues = (JSONObject)jsonObj.get(SectionType.DEFAULTS.getValue());
                for (Object defaultKeyVal : keyValues.keySet()) {
                    String key = (String)defaultKeyVal;
                    String value = (String)keyValues.get(key);
                    defaults.put(key, value);
                }
                continue;
            }
            if (!SectionType.AUTOSTORE.getValue().equals(keySectionVal)) continue;
            autoStore = (boolean)((Boolean)jsonObj.get(SectionType.AUTOSTORE.getValue()));
        }
        return new ConfigContainer(partitions, schema, profiles, defaults, autoStore);
    }
}

