/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zoslogs.method;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.ZosLogItemJsonParse;
import zowe.client.sdk.parse.ZosLogReplyJsonParse;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.JsonParserUtil;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zoslogs.input.ZosLogParams;
import zowe.client.sdk.zoslogs.response.ZosLogItem;
import zowe.client.sdk.zoslogs.response.ZosLogReply;

public class ZosLog {
    private static final String RESOURCE = "/zosmf/restconsoles/v1/log";
    private final ZosConnection connection;
    private ZosmfRequest request;

    public ZosLog(ZosConnection connection) {
        ValidateUtils.checkIllegalParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    public ZosLog(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkIllegalParameter(connection == null, "connection is null");
        this.connection = connection;
        if (!(request instanceof GetJsonZosmfRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public ZosLogReply issueCommand(ZosLogParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String defaultUrl = "https://" + this.connection.getHost() + ":" + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + this.connection.getZosmfPort() + RESOURCE;
        StringBuilder url = new StringBuilder(defaultUrl);
        String customPattern = "yyyy-MM-dd'T'HH:mm'Z'";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm'Z'");
        params.getStartTime().ifPresentOrElse(time -> url.append("?time=").append((String)time), () -> url.append("?time=").append(LocalDateTime.now().format(formatter)));
        params.getTimeRange().ifPresent(timeRange -> {
            if (params.getQueryCount() > 1) {
                url.append("&timeRange=").append((String)timeRange);
            } else {
                url.append("?timeRange=").append((String)timeRange);
            }
        });
        params.getDirection().ifPresent(direction -> {
            if (params.getQueryCount() > 1) {
                url.append("&direction=").append(direction.getValue());
            } else {
                url.append("?direction=").append(direction.getValue());
            }
        });
        params.getHardCopy().ifPresent(hardCopy -> {
            if (params.getQueryCount() > 1) {
                url.append("&hardcopy=").append(hardCopy.getValue());
            } else {
                url.append("?hardcopy=").append(hardCopy.getValue());
            }
        });
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(url.toString().replace("?&", "?"));
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no zos log response phrase")).toString();
        JSONObject jsonObject = JsonParserUtil.parse(jsonStr);
        JSONArray jsonArray = new JSONArray();
        if (jsonObject.get("items") != null) {
            jsonArray = (JSONArray)jsonObject.get("items");
        }
        ArrayList<ZosLogItem> zosLogItems = new ArrayList<ZosLogItem>();
        boolean isProcessResponse = params.isProcessResponses();
        for (Object itemJsonObj : jsonArray) {
            ZosLogItemJsonParse parser = (ZosLogItemJsonParse)JsonParseFactory.buildParser(ParseType.ZOS_LOG_ITEM);
            zosLogItems.add(parser.parseResponse(itemJsonObj, isProcessResponse));
        }
        ZosLogReplyJsonParse parser = (ZosLogReplyJsonParse)JsonParseFactory.buildParser(ParseType.ZOS_LOG_REPLY);
        return parser.parseResponse(jsonObject, zosLogItems);
    }
}

