/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfauth.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosmfauth.input.PasswordParams;

public class ZosmfPassword {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public ZosmfPassword(ZosConnection connection) {
        ValidateUtils.checkIllegalParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    public ZosmfPassword(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkIllegalParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalArgumentException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response changePassword(PasswordParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/services/authenticate";
        HashMap<String, String> passwordMap = new HashMap<String, String>();
        passwordMap.put("userID", params.getUserId());
        passwordMap.put("oldPwd", params.getOldPwd());
        passwordMap.put("newPwd", params.getNewPwd());
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(passwordMap).toJSONString());
        return this.request.executeRequest();
    }
}

