/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PostJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.dsn.input.CreateParams;

public class DsnCreate {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public DsnCreate(ZosConnection connection) {
        ValidateUtils.checkIllegalParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    public DsnCreate(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkIllegalParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PostJsonZosmfRequest)) {
            throw new IllegalStateException("POST_JSON request type required");
        }
        this.request = request;
    }

    public Response create(String dataSetName, CreateParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isBlank(), "dataSetName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/restfiles/ds/" + EncodeUtils.encodeURIComponent(dataSetName);
        HashMap createMap = new HashMap();
        params.getVolser().ifPresent(v -> createMap.put("volser", v));
        params.getUnit().ifPresent(v -> createMap.put("unit", v));
        params.getDsorg().ifPresent(v -> createMap.put("dsorg", v));
        params.getAlcunit().ifPresent(v -> createMap.put("alcunit", v));
        params.getPrimary().ifPresent(v -> createMap.put("primary", v));
        params.getSecondary().ifPresent(v -> createMap.put("secondary", v));
        params.getDirblk().ifPresent(v -> createMap.put("dirblk", v));
        params.getAvgblk().ifPresent(v -> createMap.put("avgblk", v));
        params.getRecfm().ifPresent(v -> createMap.put("recfm", v));
        params.getBlksize().ifPresent(v -> createMap.put("blksize", v));
        params.getLrecl().ifPresent(v -> createMap.put("lrecl", v));
        params.getStorclass().ifPresent(v -> createMap.put("storclass", v));
        params.getStorclass().ifPresent(v -> createMap.put("mgntclass", v));
        params.getMgntclass().ifPresent(v -> createMap.put("mgntclass", v));
        params.getDataclass().ifPresent(v -> createMap.put("dataclass", v));
        params.getDsntype().ifPresent(v -> createMap.put("dsntype", v));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.POST_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject((Map)createMap).toString());
        return this.request.executeRequest();
    }
}

