/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.DeleteJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class DsnDelete {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public DsnDelete(ZosConnection connection) {
        ValidateUtils.checkIllegalParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    public DsnDelete(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkIllegalParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof DeleteJsonZosmfRequest)) {
            throw new IllegalStateException("DELETE_JSON request type required");
        }
        this.request = request;
    }

    public Response delete(String dataSetName, String memberName) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isBlank(), "dataSetName not specified");
        ValidateUtils.checkNullParameter(memberName == null, "memberName is null");
        ValidateUtils.checkIllegalParameter(memberName.isBlank(), "memberName not specified");
        return this.delete(String.format("%s(%s)", dataSetName, memberName));
    }

    public Response delete(String dataSetName) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isBlank(), "dataSetName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/restfiles/ds/" + EncodeUtils.encodeURIComponent(dataSetName);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.DELETE_JSON);
        }
        this.request.setUrl(url);
        return this.request.executeRequest();
    }
}

