/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.DeleteJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfHeaders;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.ModifyJobParams;
import zowe.client.sdk.zosjobs.response.Job;

public class JobDelete {
    private static final Logger LOG = LoggerFactory.getLogger(JobDelete.class);
    private final ZosConnection connection;
    private ZosmfRequest request;

    public JobDelete(ZosConnection connection) {
        ValidateUtils.checkIllegalParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    public JobDelete(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkIllegalParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof DeleteJsonZosmfRequest)) {
            throw new IllegalStateException("DELETE_JSON request type required");
        }
        this.request = request;
    }

    public Response delete(String jobName, String jobId, String version) throws ZosmfRequestException {
        return this.deleteCommon(new ModifyJobParams.Builder(jobName, jobId).version(version).build());
    }

    public Response deleteCommon(ModifyJobParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/restjobs/jobs/" + params.getJobName().get() + "/" + params.getJobId().get();
        HashMap<String, String> headers = new HashMap<String, String>();
        String version = params.getVersion().orElse("1.0");
        if ("1.0".equals(version)) {
            LOG.debug("version 1.0 specified which will result in asynchronous processing for the request");
            headers.put((String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_1").get(0), (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_1").get(1));
        } else if ("2.0".equals(version)) {
            LOG.debug("version 2.0 specified which will result in synchronous processing for the request");
            headers.put((String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_2").get(0), (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_2").get(1));
        } else {
            throw new IllegalArgumentException("invalid version specified");
        }
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.DELETE_JSON);
        }
        this.request.setHeaders(headers);
        this.request.setUrl(url);
        return this.request.executeRequest();
    }

    public Response deleteByJob(Job job, String version) throws ZosmfRequestException {
        String jobName = job.getJobName().orElse("");
        String jobId = job.getJobId().orElse("");
        return this.deleteCommon(new ModifyJobParams.Builder(jobName, jobId).version(version).build());
    }
}

