/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import java.util.Optional;
import zowe.client.sdk.core.SshConnection;

public final class ValidateUtils {
    private ValidateUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void checkIllegalParameter(boolean check, String msg) {
        Optional<String> message = Optional.ofNullable(msg);
        if (check) {
            throw new IllegalArgumentException(message.orElse("empty message specified"));
        }
    }

    public static void checkNullParameter(boolean check, String msg) {
        Optional<String> message = Optional.ofNullable(msg);
        if (check) {
            throw new NullPointerException(message.orElse("empty message specified"));
        }
    }

    public static void checkSshConnection(SshConnection connection) {
        if (connection == null || connection.getHost() == null || connection.getPassword() == null || connection.getUser() == null || connection.getHost().isBlank() || connection.getPassword().isBlank() || connection.getUser().isBlank()) {
            throw new IllegalStateException("SSH connection data not setup properly");
        }
    }
}

