/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.response;

import java.util.Optional;
import java.util.OptionalLong;
import zowe.client.sdk.zosjobs.response.JobStepData;

public class Job {
    private final Optional<String> jobId;
    private final Optional<String> jobName;
    private final Optional<String> subSystem;
    private final Optional<String> owner;
    private final Optional<String> status;
    private final Optional<String> type;
    private final Optional<String> classs;
    private final Optional<String> retCode;
    private final Optional<JobStepData[]> stepData;
    private final Optional<String> url;
    private final Optional<String> filesUrl;
    private final Optional<String> jobCorrelator;
    private final OptionalLong phase;
    private final Optional<String> phaseName;

    private Job(Builder builder) {
        this.jobId = Optional.ofNullable(builder.jobId);
        this.jobName = Optional.ofNullable(builder.jobName);
        this.subSystem = Optional.ofNullable(builder.subSystem);
        this.owner = Optional.ofNullable(builder.owner);
        this.status = Optional.ofNullable(builder.status);
        this.type = Optional.ofNullable(builder.type);
        this.classs = Optional.ofNullable(builder.classs);
        this.retCode = Optional.ofNullable(builder.retCode);
        this.stepData = Optional.ofNullable(builder.stepData);
        this.url = Optional.ofNullable(builder.url);
        this.filesUrl = Optional.ofNullable(builder.filesUrl);
        this.jobCorrelator = Optional.ofNullable(builder.jobCorrelator);
        this.phase = builder.phase == null ? OptionalLong.empty() : OptionalLong.of(builder.phase);
        this.phaseName = Optional.ofNullable(builder.phaseName);
    }

    public Optional<String> getClasss() {
        return this.classs;
    }

    public Optional<String> getFilesUrl() {
        return this.filesUrl;
    }

    public Optional<String> getJobCorrelator() {
        return this.jobCorrelator;
    }

    public Optional<String> getJobId() {
        return this.jobId;
    }

    public Optional<String> getJobName() {
        return this.jobName;
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public OptionalLong getPhase() {
        return this.phase;
    }

    public Optional<String> getPhaseName() {
        return this.phaseName;
    }

    public Optional<String> getRetCode() {
        return this.retCode;
    }

    public Optional<String> getStatus() {
        return this.status;
    }

    public Optional<JobStepData[]> getStepData() {
        return this.stepData;
    }

    public Optional<String> getSubSystem() {
        return this.subSystem;
    }

    public Optional<String> getType() {
        return this.type;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public String toString() {
        return "Job{jobId=" + this.jobId + ", jobName=" + this.jobName + ", subSystem=" + this.subSystem + ", owner=" + this.owner + ", status=" + this.status + ", type=" + this.type + ", classs=" + this.classs + ", retCode=" + this.retCode + ", stepData=" + this.stepData + ", url=" + this.url + ", filesUrl=" + this.filesUrl + ", jobCorrelator=" + this.jobCorrelator + ", phase=" + this.phase + ", phaseName=" + this.phaseName + "}";
    }

    public static class Builder {
        private String jobId;
        private String jobName;
        private String subSystem;
        private String owner;
        private String status;
        private String type;
        private String classs;
        private String retCode;
        private JobStepData[] stepData;
        private String url;
        private String filesUrl;
        private String jobCorrelator;
        private Long phase;
        private String phaseName;

        public Builder classs(String classs) {
            this.classs = classs;
            return this;
        }

        public Builder filesUrl(String filesUrl) {
            this.filesUrl = filesUrl;
            return this;
        }

        public Builder jobCorrelator(String jobCorrelator) {
            this.jobCorrelator = jobCorrelator;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder phase(Long phase) {
            this.phase = phase;
            return this;
        }

        public Builder phaseName(String phaseName) {
            this.phaseName = phaseName;
            return this;
        }

        public Builder retCode(String retCode) {
            this.retCode = retCode;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder stepData(JobStepData[] stepData) {
            this.stepData = stepData;
            return this;
        }

        public Builder subSystem(String subSystem) {
            this.subSystem = subSystem;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Job build() {
            return new Job(this);
        }
    }
}

