/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.ChangeOwnerParams;

public class UssChangeOwner {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssChangeOwner(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    public UssChangeOwner(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response change(String targetPath, String owner) throws ZosmfRequestException {
        return this.changeCommon(targetPath, new ChangeOwnerParams.Builder().owner(owner).build());
    }

    public Response changeCommon(String targetPath, ChangeOwnerParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(targetPath == null, "targetPath is null");
        ValidateUtils.checkIllegalParameter(targetPath.isBlank(), "targetPath not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        HashMap<String, String> changeOnerMap = new HashMap<String, String>();
        changeOnerMap.put("request", "chown");
        params.getGroup().ifPresent(group -> changeOnerMap.put("group", (String)group));
        if (params.isRecursive()) {
            changeOnerMap.put("recursive", "true");
        }
        params.getLinks().ifPresent(type -> changeOnerMap.put("links", type.getValue()));
        String errMsg = "owner not specified";
        changeOnerMap.put("owner", params.getOwner().orElseThrow(() -> new IllegalStateException("owner not specified")));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(changeOnerMap).toString());
        return this.request.executeRequest();
    }
}

