/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class DsnRename {
    private final ZosConnection connection;
    private ZosmfRequest request;
    private String url;

    public DsnRename(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    public DsnRename(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response dataSetName(String dataSetName, String newDataSetName) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isBlank(), "dataSetName not specified");
        ValidateUtils.checkNullParameter(newDataSetName == null, "newDataSetName is null");
        ValidateUtils.checkIllegalParameter(newDataSetName.isBlank(), "newDataSetName not specified");
        this.setUrl(newDataSetName);
        return this.executeCommon(dataSetName);
    }

    public Response memberName(String fromDataSetName, String memberName, String newMemberName) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(fromDataSetName == null, "fromDataSetName is null");
        ValidateUtils.checkIllegalParameter(fromDataSetName.isBlank(), "fromDataSetName not specified");
        ValidateUtils.checkNullParameter(memberName == null, "memberName is null");
        ValidateUtils.checkIllegalParameter(memberName.isBlank(), "memberName not specified");
        ValidateUtils.checkNullParameter(newMemberName == null, "newMemberName is null");
        ValidateUtils.checkIllegalParameter(newMemberName.isBlank(), "newMemberName not specified");
        this.setUrl(fromDataSetName, newMemberName);
        return this.executeCommon(fromDataSetName, memberName);
    }

    private void setUrl(String ... args) {
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/restfiles/ds/" + EncodeUtils.encodeURIComponent(args[0]);
        if (args.length > 1) {
            this.url = this.url + "(" + EncodeUtils.encodeURIComponent(args[1]) + ")";
        }
    }

    private Response executeCommon(String ... args) throws ZosmfRequestException {
        HashMap<String, Object> renameMap = new HashMap<String, Object>();
        renameMap.put("request", "rename");
        HashMap<String, String> fromDataSetReq = new HashMap<String, String>();
        fromDataSetReq.put("dsn", args[0]);
        if (args.length > 1) {
            fromDataSetReq.put("member", args[1]);
        }
        JSONObject fromDataSetObj = new JSONObject(fromDataSetReq);
        renameMap.put("from-dataset", fromDataSetObj);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(this.url);
        this.request.setBody(new JSONObject(renameMap).toString());
        return this.request.executeRequest();
    }
}

