/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfinfo.methods;

import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.JsonParserUtil;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosmfinfo.response.ZosmfInfoResponse;

public class ZosmfStatus {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public ZosmfStatus(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    public ZosmfStatus(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof GetJsonZosmfRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public ZosmfInfoResponse get() throws ZosmfRequestException {
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/info";
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(url);
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no z/osmf status response phrase")).toString();
        JSONObject jsonObject = JsonParserUtil.parse(jsonStr);
        return (ZosmfInfoResponse)JsonParseFactory.buildParser(ParseType.ZOSMF_INFO).parseResponse(jsonObject);
    }
}

