/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.method;

import java.util.ArrayList;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.input.StartTsoParams;
import zowe.client.sdk.zostso.lifecycle.SendTso;
import zowe.client.sdk.zostso.lifecycle.StartTso;
import zowe.client.sdk.zostso.lifecycle.StopTso;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;
import zowe.client.sdk.zostso.response.IssueResponse;
import zowe.client.sdk.zostso.response.SendResponse;
import zowe.client.sdk.zostso.response.StartStopResponse;
import zowe.client.sdk.zostso.response.StartStopResponses;

public class IssueTso {
    private final ZosConnection connection;

    public IssueTso(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    public IssueResponse issueCommand(String accountNumber, String command) throws ZosmfRequestException {
        return this.issueCommand(accountNumber, command, null);
    }

    public IssueResponse issueCommand(String accountNumber, String command, StartTsoParams startParams) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(accountNumber == null, "accountNumber is null");
        ValidateUtils.checkNullParameter(command == null, "command is null");
        ValidateUtils.checkIllegalParameter(accountNumber.isBlank(), "accountNumber not specified");
        ValidateUtils.checkIllegalParameter(command.isBlank(), "command not specified");
        StartTso startTso = new StartTso(this.connection);
        StartStopResponses startResponse = startTso.start(accountNumber, startParams);
        if (startResponse == null) {
            throw new IllegalStateException("Severe failure getting started TSO address space.");
        }
        if (!startResponse.isSuccess()) {
            throw new IllegalStateException("TSO address space failed to start. Error: " + startResponse.getFailureResponse().orElse("Unknown error"));
        }
        IssueResponse issueResponse = new IssueResponse();
        issueResponse.setStartResponse(startResponse);
        ArrayList<ZosmfTsoResponse> zosmfTsoResponses = new ArrayList<ZosmfTsoResponse>();
        zosmfTsoResponses.add(startResponse.getZosmfTsoResponse().orElseThrow(() -> new IllegalStateException("no zosmf start tso response")));
        String servletKey = startResponse.getServletKey().orElseThrow(() -> new IllegalStateException("no servletKey key value returned from startTso"));
        SendTso sendTso = new SendTso(this.connection);
        SendResponse sendResponse = sendTso.sendDataToTsoCollect(servletKey, command);
        issueResponse.setSuccess(sendResponse.isSuccess());
        zosmfTsoResponses.addAll(sendResponse.getZosmfResponses());
        issueResponse.setZosmfResponses(zosmfTsoResponses);
        issueResponse.setCommandResponses(sendResponse.getCommandResponse().orElseThrow(() -> new IllegalStateException("error getting tso command response")));
        StopTso stopTso = new StopTso(this.connection);
        StartStopResponse stopResponse = stopTso.stop(servletKey);
        issueResponse.setStopResponse(stopResponse);
        return issueResponse;
    }
}

