/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosconsole.service;

import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosconsole.response.ConsoleResponse;
import zowe.client.sdk.zosconsole.response.ZosmfIssueResponse;

public final class ConsoleResponseService {
    private static ConsoleResponseService INSTANCE;

    private ConsoleResponseService() {
    }

    public static synchronized ConsoleResponseService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConsoleResponseService();
        }
        return INSTANCE;
    }

    public ConsoleResponse buildConsoleResponse(ZosmfIssueResponse zosmfResponse, boolean processResponses) {
        ValidateUtils.checkNullParameter(zosmfResponse == null, "zosmfResponse is null");
        ConsoleResponse consoleResponse = new ConsoleResponse();
        consoleResponse.setZosmfResponse(zosmfResponse);
        consoleResponse.setSuccess(true);
        if (zosmfResponse.getSolKeyDetected().isPresent()) {
            consoleResponse.setKeywordDetected(true);
        }
        if (zosmfResponse.getCmdResponse().isPresent()) {
            String responseStr = zosmfResponse.getCmdResponse().get();
            consoleResponse.setCommandResponse(responseStr);
            if (processResponses && !responseStr.isBlank()) {
                responseStr = responseStr.replace('\r', '\n');
                consoleResponse.setCommandResponse(responseStr);
                if (responseStr.charAt(responseStr.length() - 1) != '\n') {
                    consoleResponse.setCommandResponse(responseStr + "\n");
                }
            }
        }
        zosmfResponse.getCmdResponseKey().ifPresent(consoleResponse::setLastResponseKey);
        zosmfResponse.getCmdResponseUrl().ifPresent(consoleResponse::setCmdResponseUrl);
        return consoleResponse;
    }
}

