/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.SetAclParams;
import zowe.client.sdk.zosfiles.uss.types.DeleteAclType;

public class UssSetAcl {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssSetAcl(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssSetAcl(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response set(String targetPath, String value) throws ZosmfRequestException {
        return this.setAclCommon(targetPath, new SetAclParams.Builder().setSet(value).build());
    }

    public Response modify(String targetPath, String value) throws ZosmfRequestException {
        return this.setAclCommon(targetPath, new SetAclParams.Builder().setModify(value).build());
    }

    public Response delete(String targetPath, String value) throws ZosmfRequestException {
        return this.setAclCommon(targetPath, new SetAclParams.Builder().setDelete(value).build());
    }

    public Response deleteByType(String targetPath, DeleteAclType deleteType) throws ZosmfRequestException {
        return this.setAclCommon(targetPath, new SetAclParams.Builder().setDeleteType(deleteType).build());
    }

    public Response setAclCommon(String targetPath, SetAclParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(targetPath == null, "targetPath is null");
        ValidateUtils.checkIllegalParameter(targetPath.isBlank(), "targetPath not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getSet().isEmpty() && params.getModify().isEmpty() && params.getDelete().isEmpty() && params.getDeleteType().isEmpty(), "set, modify, delete, and delete type are all empty");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        HashMap<String, Object> setAclMap = new HashMap<String, Object>();
        setAclMap.put("request", "setfacl");
        if (params.isAbort()) {
            setAclMap.put("abort", params.isAbort());
        }
        params.getLinks().ifPresent(links -> setAclMap.put("links", links.getValue()));
        params.getDeleteType().ifPresent(deleteType -> setAclMap.put("delete-type", deleteType.getValue()));
        params.getSet().ifPresent(set -> setAclMap.put("set", set));
        params.getModify().ifPresent(modify -> setAclMap.put("modify", modify));
        params.getDelete().ifPresent(delete -> setAclMap.put("delete", delete));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(setAclMap).toString());
        return this.request.executeRequest();
    }
}

