/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.lifecycle;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.input.SendTsoParams;
import zowe.client.sdk.zostso.message.TsoMessage;
import zowe.client.sdk.zostso.message.TsoMessages;
import zowe.client.sdk.zostso.message.TsoResponseMessage;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;
import zowe.client.sdk.zostso.response.CollectedResponses;
import zowe.client.sdk.zostso.response.SendResponse;
import zowe.client.sdk.zostso.service.TsoResponseService;

public class SendTso {
    private static final Logger LOG = LoggerFactory.getLogger(SendTso.class);
    private final ZosConnection connection;
    private ZosmfRequest request;

    public SendTso(ZosConnection connection) {
        this.connection = connection;
    }

    SendTso(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    private static SendResponse createResponse(CollectedResponses responses) {
        return new SendResponse(true, responses.getTsos(), responses.getMessages().orElseThrow(() -> new IllegalStateException("no responses tso messages exist")));
    }

    public CollectedResponses getAllResponses(ZosmfTsoResponse tso) throws ZosmfRequestException {
        boolean done = false;
        StringBuilder messages = new StringBuilder();
        ArrayList<ZosmfTsoResponse> tsos = new ArrayList<ZosmfTsoResponse>();
        tsos.add(tso);
        while (!done) {
            if (!tso.getTsoData().isEmpty()) {
                LOG.debug(tso.getTsoData().toString());
                for (TsoMessages tsoDatum : tso.getTsoData()) {
                    if (tsoDatum.getTsoMessage().isPresent()) {
                        TsoMessage tsoMsg = tsoDatum.getTsoMessage().get();
                        tsoMsg.getData().ifPresent(data -> {
                            messages.append((String)data);
                            messages.append("\n");
                        });
                        continue;
                    }
                    if (!tsoDatum.getTsoPrompt().isPresent()) continue;
                    if (messages.toString().contains("IKJ56602I COMMAND SYSTEM RESTARTING DUE TO ERROR")) {
                        String IKJ56602I = "IKJ56602I COMMAND SYSTEM RESTARTING DUE TO ERROR";
                        String msg = messages.toString();
                        int startIndex = msg.indexOf("IKJ56602I");
                        messages.delete(startIndex, startIndex + "IKJ56602I COMMAND SYSTEM RESTARTING DUE TO ERROR".length() + "\nREADY".length());
                        continue;
                    }
                    if (messages.length() <= 0 || !messages.toString().contains("READY") && !messages.toString().contains("REENTER")) continue;
                    done = true;
                }
            }
            if (done) continue;
            tso = this.getDataFromTso(tso.getServletKey().orElseThrow(() -> new IllegalStateException("servlet key missing")));
            tsos.add(tso);
        }
        return new CollectedResponses(tsos, messages.toString());
    }

    private ZosmfTsoResponse getDataFromTso(String servletKey) throws ZosmfRequestException {
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/tsoApp/tso/" + servletKey;
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody("");
        return new TsoResponseService(this.request.executeRequest()).getZosmfTsoResponse();
    }

    private String getTsoResponseSendMessage(TsoResponseMessage tsoResponseMessage) {
        return "{\"TSO RESPONSE\":{\"VERSION\":\"" + tsoResponseMessage.getVersion().orElse("") + "\",\"DATA\":\"" + tsoResponseMessage.getData().orElse("") + "\"}}";
    }

    public SendResponse sendDataToTsoCollect(String servletKey, String command) throws ZosmfRequestException {
        ZosmfTsoResponse putResponse = this.sendDataToTsoCommon(new SendTsoParams(servletKey, command));
        CollectedResponses responses = this.getAllResponses(putResponse);
        return SendTso.createResponse(responses);
    }

    public ZosmfTsoResponse sendDataToTsoCommon(SendTsoParams commandParams) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(commandParams == null, "commandParams is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + (this.connection.getBasePath().isPresent() ? this.connection.getBasePath().get() : "") + "/zosmf/tsoApp/tso/" + commandParams.getServletKey() + "?readReply=false";
        TsoResponseMessage tsoResponseMessage = new TsoResponseMessage("0100", commandParams.getData());
        String jobObjBody = this.getTsoResponseSendMessage(tsoResponseMessage);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(jobObjBody);
        return new TsoResponseService(this.request.executeRequest()).getZosmfTsoResponse();
    }
}

