/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kong.unirest.core.Config;
import kong.unirest.core.HttpRequestSummary;
import kong.unirest.core.HttpResponseSummary;
import kong.unirest.core.RawResponse;
import kong.unirest.core.ResponseSummary;

public abstract class RawResponseBase
implements RawResponse {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
    private final HttpRequestSummary reqSummary;
    protected Config config;

    protected RawResponseBase(Config config, HttpRequestSummary summary) {
        this.config = config;
        this.reqSummary = summary;
    }

    protected String getCharSet() {
        String contentType = this.getContentType();
        String responseCharset = this.getCharsetFromContentType(contentType);
        if (responseCharset != null && !responseCharset.trim().equals("")) {
            return responseCharset;
        }
        return this.config.getDefaultResponseEncoding();
    }

    private String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m4 = CHARSET_PATTERN.matcher(contentType);
        if (m4.find()) {
            return m4.group(1).trim().toUpperCase();
        }
        return null;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public HttpResponseSummary toSummary() {
        return new ResponseSummary(this);
    }

    @Override
    public HttpRequestSummary getRequestSummary() {
        return this.reqSummary;
    }
}

