/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.parse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.parse.DatasetJsonParse;
import zowe.client.sdk.parse.JobFileJsonParse;
import zowe.client.sdk.parse.JobJsonParse;
import zowe.client.sdk.parse.JsonParse;
import zowe.client.sdk.parse.MemberJsonParse;
import zowe.client.sdk.parse.MvsConsoleJsonParse;
import zowe.client.sdk.parse.PropsJsonParse;
import zowe.client.sdk.parse.SystemInfoJsonParse;
import zowe.client.sdk.parse.SystemsJsonParse;
import zowe.client.sdk.parse.TsoJsonParse;
import zowe.client.sdk.parse.TsoStopJsonParse;
import zowe.client.sdk.parse.UnixFileJsonParse;
import zowe.client.sdk.parse.UnixZfsJsonParse;
import zowe.client.sdk.parse.ZosLogItemJsonParse;
import zowe.client.sdk.parse.ZosLogReplyJsonParse;
import zowe.client.sdk.parse.type.ParseType;

public final class JsonParseFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JsonParseFactory.class);

    private JsonParseFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static JsonParse buildParser(ParseType type) {
        JsonParse parseResponse;
        LOG.debug(type.name());
        switch (type) {
            case DATASET: {
                parseResponse = DatasetJsonParse.getInstance();
                break;
            }
            case JOB: {
                parseResponse = JobJsonParse.getInstance();
                break;
            }
            case JOB_FILE: {
                parseResponse = JobFileJsonParse.getInstance();
                break;
            }
            case MEMBER: {
                parseResponse = MemberJsonParse.getInstance();
                break;
            }
            case MVS_CONSOLE: {
                parseResponse = MvsConsoleJsonParse.getInstance();
                break;
            }
            case PROPS: {
                parseResponse = PropsJsonParse.getInstance();
                break;
            }
            case TSO_CONSOLE: {
                parseResponse = TsoJsonParse.getInstance();
                break;
            }
            case TSO_STOP: {
                parseResponse = TsoStopJsonParse.getInstance();
                break;
            }
            case UNIX_FILE: {
                parseResponse = UnixFileJsonParse.getInstance();
                break;
            }
            case UNIX_ZFS: {
                parseResponse = UnixZfsJsonParse.getInstance();
                break;
            }
            case ZOS_LOG_ITEM: {
                parseResponse = ZosLogItemJsonParse.getInstance();
                break;
            }
            case ZOS_LOG_REPLY: {
                parseResponse = ZosLogReplyJsonParse.getInstance();
                break;
            }
            case ZOSMF_SYSTEMS: {
                parseResponse = SystemsJsonParse.getInstance();
                break;
            }
            case ZOSMF_INFO: {
                parseResponse = SystemInfoJsonParse.getInstance();
                break;
            }
            default: {
                throw new IllegalStateException("no valid ParseType type specified");
            }
        }
        return parseResponse;
    }
}

