/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.types.DeleteAclType;
import zowe.client.sdk.zosfiles.uss.types.LinkType;

public class SetAclParams {
    private final boolean abort;
    private final Optional<LinkType> links;
    private final Optional<DeleteAclType> deleteType;
    private final Optional<String> set;
    private final Optional<String> modify;
    private final Optional<String> delete;

    public SetAclParams(Builder builder) {
        this.abort = builder.abort;
        this.links = Optional.ofNullable(builder.links);
        this.deleteType = Optional.ofNullable(builder.deleteType);
        this.set = Optional.ofNullable(builder.set);
        this.modify = Optional.ofNullable(builder.modify);
        this.delete = Optional.ofNullable(builder.delete);
    }

    public boolean isAbort() {
        return this.abort;
    }

    public Optional<LinkType> getLinks() {
        return this.links;
    }

    public Optional<DeleteAclType> getDeleteType() {
        return this.deleteType;
    }

    public Optional<String> getSet() {
        return this.set;
    }

    public Optional<String> getModify() {
        return this.modify;
    }

    public Optional<String> getDelete() {
        return this.delete;
    }

    public String toString() {
        return "SetAclParams{abort=" + this.abort + ", links=" + this.links + ", deleteType=" + this.deleteType + ", set=" + this.set + ", modify=" + this.modify + ", delete=" + this.delete + "}";
    }

    public static class Builder {
        private boolean abort = false;
        private LinkType links = LinkType.FOLLOW;
        private DeleteAclType deleteType;
        private String set;
        private String modify;
        private String delete;

        public Builder setAbort(boolean abort) {
            this.abort = abort;
            return this;
        }

        public Builder setLinks(LinkType links) {
            this.links = links;
            return this;
        }

        public Builder setDeleteType(DeleteAclType deleteType) {
            ValidateUtils.checkNullParameter(deleteType == null, "deleteType is null");
            this.deleteType = deleteType;
            return this;
        }

        public Builder setSet(String set) {
            ValidateUtils.checkNullParameter(set == null, "set is null");
            ValidateUtils.checkIllegalParameter(set.isBlank(), "set not specified");
            this.set = set;
            return this;
        }

        public Builder setModify(String modify) {
            ValidateUtils.checkNullParameter(modify == null, "modify is null");
            ValidateUtils.checkIllegalParameter(modify.isBlank(), "modify not specified");
            this.modify = modify;
            return this;
        }

        public Builder setDelete(String delete) {
            ValidateUtils.checkNullParameter(delete == null, "delete is null");
            ValidateUtils.checkIllegalParameter(delete.isBlank(), "delete not specified");
            this.delete = delete;
            return this;
        }

        public SetAclParams build() {
            return new SetAclParams(this);
        }
    }
}

