/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.teamconfig.service;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.teamconfig.exception.TeamConfigException;
import zowe.client.sdk.teamconfig.keytar.IKeyTar;
import zowe.client.sdk.teamconfig.keytar.KeyTarConfig;

public class KeyTarService {
    private static final Logger LOG = LoggerFactory.getLogger(KeyTarService.class);
    private final List<String> serviceNames = List.of("Zowe", "Zowe-Plugin");
    private final IKeyTar keyTar;

    public KeyTarService(IKeyTar keyTar) {
        this.keyTar = keyTar;
    }

    public KeyTarConfig getKeyTarConfig() throws TeamConfigException {
        List<Object> keyTarConfigs = new ArrayList();
        String accountName = "secure_config_props";
        this.keyTar.setAccountName("secure_config_props");
        for (String serviceName : this.serviceNames) {
            this.keyTar.setServiceName(serviceName);
            try {
                this.keyTar.processKey();
            }
            catch (TeamConfigException e) {
                LOG.debug(e.getMessage());
                continue;
            }
            LOG.debug("KeyTar Value {}", (Object)this.keyTar.getKeyTarValue());
            keyTarConfigs = this.keyTar.getKeyConfigs();
            break;
        }
        if (keyTarConfigs.isEmpty()) {
            throw new IllegalStateException("No OS credential store related to Zowe found.");
        }
        if (keyTarConfigs.size() > 1) {
            LOG.debug("Multiple OS credential stores found related to Zowe. Returning the first one on list.");
        }
        return (KeyTarConfig)keyTarConfigs.get(0);
    }
}

