/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.core;

import kong.unirest.core.Cookie;
import zowe.client.sdk.core.AuthType;
import zowe.client.sdk.core.ZosConnection;

public class ZosConnectionFactory {
    private ZosConnectionFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static ZosConnection createBasicConnection(String host, String port, String user, String password) {
        return ZosConnectionFactory.createBasicZosConnection(host, port, user, password, null);
    }

    public static ZosConnection createBasicConnection(String host, String port, String user, String password, String basePath) {
        if (basePath == null || basePath.isBlank()) {
            throw new IllegalStateException("basePath is either null or empty");
        }
        return ZosConnectionFactory.createBasicZosConnection(host, port, user, password, basePath);
    }

    private static ZosConnection createBasicZosConnection(String host, String port, String user, String password, String basePath) {
        if (host == null || host.isBlank()) {
            throw new IllegalStateException("host is either null or empty");
        }
        if (port == null || port.isBlank()) {
            throw new IllegalStateException("port is either null or empty");
        }
        if (user == null || user.isBlank()) {
            throw new IllegalStateException("user is either null or empty");
        }
        if (password == null || password.isBlank()) {
            throw new IllegalStateException("password is either null or empty");
        }
        ZosConnection zosConnection = new ZosConnection(host, port, AuthType.BASIC);
        zosConnection.setUser(user);
        zosConnection.setPassword(password);
        zosConnection.setBasePath(basePath);
        return zosConnection;
    }

    public static ZosConnection createTokenConnection(String host, String port, Cookie token) {
        return ZosConnectionFactory.createTokenZosConnection(host, port, token, null);
    }

    public static ZosConnection createTokenConnection(String host, String port, Cookie token, String basePath) {
        if (basePath == null || basePath.isBlank()) {
            throw new IllegalStateException("basePath is either null or empty");
        }
        return ZosConnectionFactory.createTokenZosConnection(host, port, token, basePath);
    }

    private static ZosConnection createTokenZosConnection(String host, String port, Cookie token, String basePath) {
        if (host == null || host.isBlank()) {
            throw new IllegalStateException("host is either null or empty");
        }
        if (port == null || port.isBlank()) {
            throw new IllegalStateException("port is either null or empty");
        }
        if (token == null) {
            throw new IllegalStateException("token is null");
        }
        ZosConnection zosConnection = new ZosConnection(host, port, AuthType.TOKEN);
        zosConnection.setToken(token);
        zosConnection.setBasePath(basePath);
        return zosConnection;
    }

    public static ZosConnection createSslConnection(String host, String port, String certFilePath, String certPassword) {
        return ZosConnectionFactory.createSslZosConnection(host, port, certFilePath, certPassword, null);
    }

    public static ZosConnection createSslConnection(String host, String port, String certFilePath, String certPassword, String basePath) {
        if (basePath == null || basePath.isBlank()) {
            throw new IllegalStateException("basePath is either null or empty");
        }
        return ZosConnectionFactory.createSslZosConnection(host, port, certFilePath, certPassword, basePath);
    }

    private static ZosConnection createSslZosConnection(String host, String port, String certFilePath, String certPassword, String basePath) {
        if (host == null || host.isBlank()) {
            throw new IllegalStateException("host is either null or empty");
        }
        if (port == null || port.isBlank()) {
            throw new IllegalStateException("port is either null or empty");
        }
        if (certFilePath == null || certFilePath.isBlank()) {
            throw new IllegalStateException("certificate file path (.p12) is either null or empty");
        }
        if (certPassword == null || certPassword.isBlank()) {
            throw new IllegalStateException("certificate password is either null or empty");
        }
        ZosConnection zosConnection = new ZosConnection(host, port, AuthType.SSL);
        zosConnection.setCertFilePath(certFilePath);
        zosConnection.setCertPassword(certPassword);
        zosConnection.setBasePath(basePath);
        return zosConnection;
    }
}

