/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfHeaders;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.JsonParserUtil;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.dsn.input.ListParams;
import zowe.client.sdk.zosfiles.dsn.response.Dataset;
import zowe.client.sdk.zosfiles.dsn.response.Member;
import zowe.client.sdk.zosfiles.dsn.types.AttributeType;

public class DsnList {
    private static final Logger LOG = LoggerFactory.getLogger(DsnList.class);
    private final ZosConnection connection;
    private ZosmfRequest request;

    public DsnList(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    DsnList(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof GetJsonZosmfRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public List<Dataset> getDatasets(String dataSetName, ListParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isBlank(), "dataSetName not specified");
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList datasets = new ArrayList();
        String url = this.connection.getZosmfUrl() + "/restfiles/ds?dslevel=" + EncodeUtils.encodeURIComponent(dataSetName);
        if (params.getVolume().isPresent()) {
            url = url + "&volser=" + EncodeUtils.encodeURIComponent(params.getVolume().get());
        }
        if (params.getStart().isPresent()) {
            url = url + "&start=" + params.getStart().get();
        }
        return this.getResult(this.getResponse(params, headers, url), datasets, null);
    }

    public List<Member> getMembers(String dataSetName, ListParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isBlank(), "dataSetName not specified");
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList members = new ArrayList();
        String url = this.connection.getZosmfUrl() + "/restfiles/ds/" + EncodeUtils.encodeURIComponent(dataSetName) + "/member";
        if (params.getPattern().isPresent()) {
            url = url + "?pattern=" + EncodeUtils.encodeURIComponent(params.getPattern().get());
        }
        return this.getResult(this.getResponse(params, headers, url), null, members);
    }

    private <T> List<T> getResult(Response response, List<T> datasetLst, List<T> memberLst) throws ZosmfRequestException {
        if (response.getStatusCode().isEmpty()) {
            LOG.debug("status code not returned");
            if (datasetLst == null) {
                return memberLst;
            }
            return datasetLst;
        }
        if (response.getResponsePhrase().isEmpty()) {
            LOG.debug("response phrase not returned");
            if (datasetLst == null) {
                return memberLst;
            }
            return datasetLst;
        }
        int statusCode = response.getStatusCode().getAsInt();
        if (statusCode < 100 || statusCode > 299) {
            if (response.getStatusText().isEmpty()) {
                LOG.debug("status text not returned");
                if (datasetLst == null) {
                    return memberLst;
                }
                return datasetLst;
            }
            LOG.debug("rest status code {}", (Object)response.getStatusCode().getAsInt());
            LOG.debug("rest status text {}", (Object)response.getStatusText().get());
            String errMsg = "http status error code: " + statusCode + ", status text: " + response.getStatusText().get() + ", response phrase: " + response.getResponsePhrase().get();
            throw new IllegalStateException(errMsg);
        }
        String jsonStr = response.getResponsePhrase().get().toString();
        JSONObject jsonObject = JsonParserUtil.parse(jsonStr);
        if (jsonObject.isEmpty()) {
            if (datasetLst == null) {
                return memberLst;
            }
            return datasetLst;
        }
        JSONArray items = (JSONArray)jsonObject.get("items");
        for (Object obj : items) {
            if (datasetLst == null) {
                memberLst.add(JsonParseFactory.buildParser(ParseType.MEMBER).parseResponse(obj));
                continue;
            }
            datasetLst.add(JsonParseFactory.buildParser(ParseType.DATASET).parseResponse(obj));
        }
        if (datasetLst == null) {
            return memberLst;
        }
        return datasetLst;
    }

    private Response getResponse(ListParams params, Map<String, String> headers, String url) throws ZosmfRequestException {
        this.setHeaders(params, headers);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setupRequest();
        this.request.setHeaders(headers);
        this.request.setUrl(url);
        return this.request.executeRequest();
    }

    private void setHeaders(ListParams params, Map<String, String> headers) {
        String key = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(0);
        String value = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(1);
        headers.put(key, value);
        if (params.getAttribute().isPresent()) {
            AttributeType attribute = params.getAttribute().get();
            if (attribute == AttributeType.BASE) {
                key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_BASE").get(0);
                value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_BASE").get(1);
            } else if (attribute == AttributeType.VOL) {
                key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_VOL").get(0);
                value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_VOL").get(1);
            }
            headers.put(key, value);
        }
        if (params.getMaxLength().isPresent()) {
            key = "X-IBM-Max-Items";
            value = params.getMaxLength().get();
        } else {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MAX_ITEMS").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MAX_ITEMS").get(1);
        }
        headers.put(key, value);
        if (params.getResponseTimeout().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RESPONSE_TIMEOUT").get(0);
            value = params.getResponseTimeout().get();
            headers.put(key, value);
        }
        if (params.getRecall().isPresent()) {
            switch (params.getRecall().get().toLowerCase(Locale.ROOT)) {
                case "wait": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_WAIT").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_WAIT").get(1);
                    headers.put(key, value);
                    break;
                }
                case "nowait": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_NO_WAIT").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_NO_WAIT").get(1);
                    headers.put(key, value);
                    break;
                }
                case "error": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_ERROR").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_ERROR").get(1);
                    headers.put(key, value);
                }
            }
        }
    }
}

