/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.Map;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.DeleteJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class UssDelete {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssDelete(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssDelete(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof DeleteJsonZosmfRequest)) {
            throw new IllegalStateException("DELETE_JSON request type required");
        }
        this.request = request;
    }

    public Response delete(String targetPath) throws ZosmfRequestException {
        return this.delete(targetPath, false);
    }

    public Response delete(String targetPath, boolean recursive) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(targetPath == null, "targetPath is null");
        ValidateUtils.checkIllegalParameter(targetPath.isBlank(), "targetPath not specified");
        String url = this.connection.getZosmfUrl() + "/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.DELETE_JSON);
        }
        if (recursive) {
            this.request.setHeaders(Map.of("X-IBM-Option", "recursive"));
        }
        this.request.setupRequest();
        this.request.setUrl(url);
        return this.request.executeRequest();
    }

    public Response deleteZfs(String fileSystemName) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(fileSystemName == null, "fileSystemName is null");
        ValidateUtils.checkIllegalParameter(fileSystemName.isBlank(), "fileSystemName not specified");
        String url = this.connection.getZosmfUrl() + "/restfiles/mfs/zfs/" + EncodeUtils.encodeURIComponent(fileSystemName);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.DELETE_JSON);
        }
        this.request.setupRequest();
        this.request.setUrl(url);
        return this.request.executeRequest();
    }
}

