/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.lifecycle;

import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.DeleteJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.JsonParserUtil;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.input.StopTsoParams;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;
import zowe.client.sdk.zostso.response.StartStopResponse;
import zowe.client.sdk.zostso.service.TsoResponseService;

public class StopTso {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public StopTso(ZosConnection connection) {
        this.connection = connection;
    }

    StopTso(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof DeleteJsonZosmfRequest)) {
            throw new IllegalStateException("DELETE_JSON request type required");
        }
        this.request = request;
    }

    public StartStopResponse stop(String servletKey) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(servletKey == null, "servletKey is null");
        ValidateUtils.checkIllegalParameter(servletKey.isBlank(), "servletKey not specified");
        StopTsoParams commandParams = new StopTsoParams(servletKey);
        ZosmfTsoResponse zosmfResponse = this.stopCommon(commandParams);
        return new TsoResponseService(zosmfResponse).setStartStopResponse();
    }

    public ZosmfTsoResponse stopCommon(StopTsoParams commandParams) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(commandParams == null, "commandParams is null");
        String url = this.connection.getZosmfUrl() + "/tsoApp/tso/" + commandParams.getServletKey().orElseThrow(() -> new IllegalArgumentException("servletKey not specified"));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.DELETE_JSON);
        }
        this.request.setupRequest();
        this.request.setUrl(url);
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no tso stop response phrase")).toString();
        JSONObject jsonObject = JsonParserUtil.parse(jsonStr);
        return (ZosmfTsoResponse)JsonParseFactory.buildParser(ParseType.TSO_STOP).parseResponse(jsonObject);
    }
}

