/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.parse;

import org.json.simple.JSONObject;
import zowe.client.sdk.parse.JsonParse;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zoslogs.response.ZosLogItem;

public final class ZosLogItemJsonParse
implements JsonParse {
    private ZosLogItemJsonParse() {
    }

    public static ZosLogItemJsonParse getInstance() {
        return Holder.instance;
    }

    @Override
    public synchronized ZosLogItem parseResponse(Object ... args) {
        ValidateUtils.checkNullParameter(args[0] == null, "data is null");
        ValidateUtils.checkNullParameter(args[1] == null, "isProcessResponse is null");
        JSONObject data = (JSONObject)args[0];
        String message = ZosLogItemJsonParse.processMessage(data, (Boolean)args[1]);
        return new ZosLogItem.Builder().cart(data.get("cart") != null ? (String)data.get("cart") : null).color(data.get("color") != null ? (String)data.get("color") : null).jobName(data.get("jobName") != null ? (String)data.get("jobName") : null).message(message).messageId(data.get("messageId") != null ? (String)data.get("messageId") : null).replyId(data.get("replyId") != null ? (String)data.get("replyId") : null).system(data.get("system") != null ? (String)data.get("system") : null).type(data.get("type") != null ? (String)data.get("type") : null).subType(data.get("subType") != null ? (String)data.get("subType") : null).time(data.get("time") != null ? (String)data.get("time") : null).timeStamp(data.get("timestamp") != null ? (Long)data.get("timestamp") : 0L).build();
    }

    private static String processMessage(JSONObject data, boolean isProcessResponse) {
        try {
            String message = (String)data.get("message");
            if (isProcessResponse) {
                if (message.contains("\r")) {
                    message = message.replace('\r', '\n');
                }
                if (message.contains("\n\n")) {
                    message = message.replaceAll("\n\n", "\n");
                }
            }
            return message;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class Holder {
        private static final ZosLogItemJsonParse instance = new ZosLogItemJsonParse();

        private Holder() {
        }
    }
}

