/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;

public class ModifyJobParams {
    private final Optional<String> jobName;
    private final Optional<String> jobId;
    private final Optional<String> version;

    private ModifyJobParams(Builder builder) {
        this.jobName = Optional.ofNullable(builder.jobName);
        this.jobId = Optional.ofNullable(builder.jobId);
        this.version = Optional.ofNullable(builder.version);
    }

    public Optional<String> getJobId() {
        return this.jobId;
    }

    public Optional<String> getJobName() {
        return this.jobName;
    }

    public Optional<String> getVersion() {
        return this.version;
    }

    public String toString() {
        return "ModifyJobParams{jobId=" + this.jobId + ", jobName=" + this.jobName + ", version=" + this.version + "}";
    }

    public static class Builder {
        private final String jobName;
        private final String jobId;
        private String version;

        public Builder(String jobName, String jobId) {
            ValidateUtils.checkNullParameter(jobName == null, "jobName is either null or empty");
            ValidateUtils.checkIllegalParameter(jobName.isBlank(), "jobName is either null or empty");
            ValidateUtils.checkNullParameter(jobId == null, "jobId is either null or empty");
            ValidateUtils.checkIllegalParameter(jobId.isBlank(), "jobId is either null or empty");
            this.jobName = jobName;
            this.jobId = jobId;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public ModifyJobParams build() {
            return new ModifyJobParams(this);
        }
    }
}

