/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.ChangeModeParams;

public class UssChangeMode {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssChangeMode(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssChangeMode(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response change(String targetPath, ChangeModeParams params) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(targetPath, "targetPath");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = this.connection.getZosmfUrl() + "/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        HashMap<String, String> changeModeMap = new HashMap<String, String>();
        changeModeMap.put("request", "chmod");
        if (params.isRecursive()) {
            changeModeMap.put("recursive", "true");
        }
        params.getLinks().ifPresent(type -> changeModeMap.put("links", type.getValue()));
        changeModeMap.put("mode", params.getMode().orElseThrow(() -> new IllegalArgumentException("mode not specified")));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(changeModeMap).toString());
        return this.request.executeRequest();
    }
}

